/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.project.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.project.dao.ProjectInfoDao;
import com.artfess.cgpt.project.manager.ProjectInfoDetailManager;
import com.artfess.cgpt.project.manager.ProjectInfoManager;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.ProjectInfoDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectInfoManagerImpl
extends BaseManagerImpl<ProjectInfoDao, ProjectInfo>
implements ProjectInfoManager {
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private ProjectInfoDetailManager detailManager;
    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<ProjectInfo> queryAllByPage(QueryFilter<ProjectInfo> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<ProjectInfo> result = ((ProjectInfoDao)this.baseMapper).queryAllByPage((IPage<ProjectInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<ProjectInfo> queryByPage(QueryFilter<ProjectInfo> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        queryFilter.addFilter("PURCHASING_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        IPage<ProjectInfo> result = ((ProjectInfoDao)this.baseMapper).queryAllByPage((IPage<ProjectInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public ProjectInfo getDataById(String id) {
        ProjectInfo result = (ProjectInfo)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
        detailQW.eq(ProjectInfoDetail::getProjectInfoId, (Object)id);
        result.setDetailList(this.detailManager.list((Wrapper)detailQW));
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
        detailQW.in(ProjectInfoDetail::getProjectInfoId, ids);
        this.detailManager.remove((Wrapper)detailQW);
        this.accessoryService.removeBySourceIds(ids);
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(ProjectInfo entity) {
        List<ProjectInfoDetail> detailList = entity.getDetailList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        if (BeanUtil.isEmpty((Object)entity.getId(), (String[])new String[0])) {
            entity.setPreparedUserId(ContextUtil.getCurrentUserId());
            entity.setPreparedUserName(ContextUtil.getCurrentUserName());
            entity.setPreparedDate(LocalDate.now());
            if (BeanUtils.isEmpty((Object)entity.getApplicationNum())) {
                entity.setApplicationNum(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgsq_sqdbh"));
            }
        } else {
            LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
            detailQW.eq(ProjectInfoDetail::getProjectInfoId, (Object)entity.getId());
            this.detailManager.remove((Wrapper)detailQW);
            this.accessoryService.removeBySourceId(entity.getId());
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtil.isNotEmpty(detailList, (String[])new String[0]) && detailList.size() > 0) {
            detailList.stream().forEach(s -> s.setProjectInfoId(entity.getId()));
            this.detailManager.saveBatch(detailList);
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }
}

