/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.project.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBidOpeningManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationDetailManager;
import com.artfess.cgpt.bidding.manager.CalibrationManager;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBidOpening;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.Calibration;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.PushNoticeVO;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.project.dao.ProjectApprovalDao;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.ProjectApprovalPayManager;
import com.artfess.cgpt.project.manager.ProjectInfoDetailManager;
import com.artfess.cgpt.project.manager.ProjectInfoManager;
import com.artfess.cgpt.project.manager.ProjectLedgerManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.project.model.ProjectApprovalPay;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.ProjectInfoDetail;
import com.artfess.cgpt.project.model.ProjectLedger;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.ApprovalInviteVendorManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalQualificationManager;
import com.artfess.cgpt.purchasing.manager.ProjectEvaluationExpertManager;
import com.artfess.cgpt.purchasing.manager.QuotationTemplateDetailApprovalManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.ApprovalInviteVendor;
import com.artfess.cgpt.purchasing.model.MatApprovalQualification;
import com.artfess.cgpt.purchasing.model.ProjectEvaluationExpert;
import com.artfess.cgpt.purchasing.model.QuotationTemplateDetailApproval;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectApprovalManagerImpl
extends BaseManagerImpl<ProjectApprovalDao, ProjectApproval>
implements ProjectApprovalManager {
    @Value(value="${cgpt.noticeUrl}")
    private String cgptPushNoticeUrl;
    @Value(value="${wxPublic.noticeTemplateId}")
    private String wxNoticeTemplateId;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private ProjectApprovalDetailsManager detailsManager;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private TenderDocumentManager tenderDocumentManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private QuotationTemplateDetailApprovalManager quotationTemplateDetailApprovalManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private BizBidOpeningManager bidOpeningManager;
    @Autowired
    private ApprovalInviteVendorManager approvalInviteVendorManager;
    @Autowired
    private CalibrationManager calibraManager;
    @Autowired
    private CalibrationDetailManager calibraDetailManager;
    @Autowired
    private BizWinBiddingNoticeManager winBidNoticeManager;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetailManager;
    @Autowired
    private ProjectInfoDetailManager proInfoDetailManager;
    @Autowired
    private ProjectInfoManager proInfoManager;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private MatApprovalQualificationManager approvalQualificationManager;
    @Autowired
    private BizEvaluationSystemManager evaluationSystemManager;
    @Autowired
    private BizEvaluationSystemDescriptionManager evaluationSystemDescriptionManager;
    @Autowired
    private ProjectLedgerManager projectLedgerManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private ProjectApprovalPayManager payInfoManager;

    @Override
    public PageList<ProjectApproval> queryAllByPage(QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<ProjectApproval> result = ((ProjectApprovalDao)this.baseMapper).queryAllByPage((IPage<ProjectApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)detailsQW.in(ProjectApprovalDetails::getNoticeId, ids)).eq(BizModel::getIsDele, (Object)"0");
        List detailList = this.detailsManager.list((Wrapper)detailsQW);
        if (BeanUtils.isNotEmpty((Object)detailList) && detailList.size() > 0) {
            List proInfoIds;
            List proInfoDetialIds = detailList.stream().filter(s -> s.getProjectSourceType().equals(2)).map(s -> s.getMatId()).distinct().collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(proInfoDetialIds) && proInfoDetialIds.size() > 0) {
                LambdaUpdateWrapper purAppDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)purAppDetailUW.set(ProjectInfoDetail::getStatus, (Object)1)).in(ProjectInfoDetail::getId, proInfoDetialIds);
                this.proInfoDetailManager.update((Wrapper)purAppDetailUW);
            }
            if (BeanUtils.isNotEmpty(proInfoIds = detailList.stream().filter(s -> s.getProjectSourceType().equals(2)).map(s -> s.getProjectInfoId()).distinct().collect(Collectors.toList())) && proInfoIds.size() > 0) {
                LambdaUpdateWrapper purAppUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)purAppUW.set(ProjectInfo::getStatus, (Object)3)).in(ProjectInfo::getId, proInfoIds)).eq(BizModel::getIsDele, (Object)"0");
                this.proInfoManager.update((Wrapper)purAppUW);
            }
            this.detailsManager.remove((Wrapper)detailsQW);
        }
        LambdaQueryWrapper payInfoQW = new LambdaQueryWrapper();
        payInfoQW.in(ProjectApprovalPay::getNoticeId, ids);
        this.payInfoManager.remove((Wrapper)payInfoQW);
        super.removeByIds(ids);
    }

    @Override
    public ProjectApproval getDataById(String id) {
        ProjectApproval result = (ProjectApproval)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)detailsQW.eq(ProjectApprovalDetails::getNoticeId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        List detailList = this.detailsManager.list((Wrapper)detailsQW);
        if (BeanUtils.isNotEmpty((Object)detailList) && detailList.size() > 0) {
            LambdaQueryWrapper payInfoQW = new LambdaQueryWrapper();
            payInfoQW.eq(ProjectApprovalPay::getNoticeId, (Object)id);
            List payInfoList = this.payInfoManager.list((Wrapper)payInfoQW);
            if (BeanUtils.isNotEmpty((Object)payInfoList) && payInfoList.size() > 0) {
                for (ProjectApprovalDetails detail : detailList) {
                    List<ProjectApprovalPay> collect = payInfoList.stream().filter(s -> s.getNoticeDetailId().equals(detail.getId())).collect(Collectors.toList());
                    detail.setPayInfoList(collect);
                }
            }
            result.setDetailsList(detailList);
        }
        LambdaQueryWrapper quotationTemplateDetailApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId, (Object)id)).eq(QuotationTemplateDetailApproval::getProjectApprovalType, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
        result.setQuotationTemplateDetailApprovalList(this.quotationTemplateDetailApprovalManager.list((Wrapper)quotationTemplateDetailApprovalQW));
        LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)id)).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
        result.setProjectEvaluationExpertList(this.evaluationExpertManager.list((Wrapper)evaluationExpertQW));
        LambdaQueryWrapper approvalInviteVendorQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId, (Object)id)).eq(ApprovalInviteVendor::getProjectApprovalType, (Object)2);
        result.setApprovalInviteVendorList(this.approvalInviteVendorManager.list((Wrapper)approvalInviteVendorQW));
        LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
        qualificationLabelQW.eq(MatApprovalQualification::getProjectId, (Object)id);
        result.setMatApprovalQualificationList(this.approvalQualificationManager.list((Wrapper)qualificationLabelQW));
        LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.eq(TenderDocument::getProjectApprovalId, (Object)id)).eq(TenderDocument::getProjectApprovalType, (Object)2)).isNotNull(TenderDocument::getType)).eq(BizModel::getIsDele, (Object)"0");
        List documentList = this.tenderDocumentManager.list((Wrapper)tenderDocumentQW);
        if (BeanUtils.isNotEmpty((Object)documentList) && documentList.size() > 0) {
            List<TenderDocument> byDocument;
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
            List<TenderDocument> zbDocument = collect.get(1);
            if (BeanUtils.isNotEmpty(zbDocument) && zbDocument.size() > 0) {
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(this.accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }
            if (BeanUtils.isNotEmpty(byDocument = collect.get(2)) && byDocument.size() > 0) {
                byDocument.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
                result.setByDocument(byDocument);
            }
        }
        LambdaQueryWrapper evaluationSystemQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationSystemQW.eq(BizEvaluationSystem::getNoticeId, (Object)result.getId())).eq(BizEvaluationSystem::getNoticeType, (Object)2)).orderByDesc(BizEvaluationSystem::getPreparedTime)).last("limit 1");
        BizEvaluationSystem evaluationSystem = (BizEvaluationSystem)((Object)this.evaluationSystemManager.getBaseMapper().selectOne((Wrapper)evaluationSystemQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaluationSystem))) {
            LambdaQueryWrapper descriptionQW = new LambdaQueryWrapper();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)evaluationSystem.getId());
            evaluationSystem.setDescriptionList(this.evaluationSystemDescriptionManager.list((Wrapper)descriptionQW));
            result.setEvaTemplate(evaluationSystem);
        }
        return result;
    }

    @Override
    @Transactional
    public ProjectApproval saveOrUpdateEntity(ProjectApproval entity) {
        List<ProjectApprovalDetails> detailList = entity.getDetailsList();
        List<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalList = entity.getQuotationTemplateDetailApprovalList();
        TenderDocument zbDocument = entity.getZbDocument();
        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
        List<ApprovalInviteVendor> approvalInviteVendorList = entity.getApprovalInviteVendorList();
        List<MatApprovalQualification> matApprovalQualificationList = entity.getMatApprovalQualificationList();
        BizEvaluationSystem evaTemplate = entity.getEvaTemplate();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            if (BeanUtils.isEmpty((Object)entity.getNoticeCode())) {
                entity.setNoticeCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgpt_cglx"));
            }
            if (BeanUtils.isEmpty((Object)entity.getAffiliatedUserId())) {
                entity.setAffiliatedUserId(ContextUtil.getCurrentUserId());
            }
            if (BeanUtils.isEmpty((Object)entity.getNoticeReleaseUserAccount())) {
                entity.setNoticeReleaseUserAccount(ContextUtil.getCurrentUserAccount());
            }
            IGroup org = ContextUtil.getCurrentGroup();
            entity.setAffiliatedOrgId(org.getGroupId());
            entity.setAffiliatedOrgCode(org.getGroupCode());
            entity.setAffiliatedOrgName(org.getName());
            if (entity.getReleaseStatus() == 2) {
                entity.setBidStatus(3);
            } else {
                entity.setBidStatus(2);
            }
            if (BeanUtils.isEmpty((Object)entity.getCalibraStatus())) {
                entity.setCalibraStatus(0);
            }
            if (BeanUtils.isEmpty((Object)entity.getWinNoticeStatus())) {
                entity.setWinNoticeStatus(1);
            }
            if (BeanUtils.isEmpty((Object)entity.getPublicityStatus())) {
                entity.setPublicityStatus(1);
            }
            entity.setAffiliatedDate(LocalDateTime.now());
        } else {
            LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)detailsQW.eq(ProjectApprovalDetails::getNoticeId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            List hisDetailList = this.detailsManager.list((Wrapper)detailsQW);
            if (BeanUtils.isNotEmpty((Object)hisDetailList) && hisDetailList.size() > 0) {
                List proInfoIds;
                List proInfoDetialIds = hisDetailList.stream().filter(s -> s.getProjectSourceType().equals(2)).map(s -> s.getMatId()).distinct().collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(proInfoDetialIds) && proInfoDetialIds.size() > 0) {
                    LambdaUpdateWrapper purAppDetailUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)purAppDetailUW.set(ProjectInfoDetail::getStatus, (Object)1)).in(ProjectInfoDetail::getId, proInfoDetialIds);
                    this.proInfoDetailManager.update((Wrapper)purAppDetailUW);
                }
                if (BeanUtils.isNotEmpty(proInfoIds = hisDetailList.stream().filter(s -> s.getProjectSourceType().equals(2)).map(s -> s.getProjectInfoId()).distinct().collect(Collectors.toList())) && proInfoIds.size() > 0) {
                    LambdaUpdateWrapper purAppUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)purAppUW.set(ProjectInfo::getStatus, (Object)3)).in(ProjectInfo::getId, proInfoIds)).eq(BizModel::getIsDele, (Object)"0");
                    this.proInfoManager.update((Wrapper)purAppUW);
                }
                this.detailsManager.remove((Wrapper)detailsQW);
            }
            LambdaQueryWrapper quotationTemplateDetailApprovalQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId, (Object)entity.getId())).eq(QuotationTemplateDetailApproval::getProjectApprovalType, (Object)2);
            this.quotationTemplateDetailApprovalManager.remove((Wrapper)quotationTemplateDetailApprovalQW);
            LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)entity.getId())).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)2);
            this.evaluationExpertManager.remove((Wrapper)evaluationExpertQW);
            LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.select(new SFunction[]{TenderDocument::getId}).eq(TenderDocument::getProjectApprovalId, (Object)entity.getId())).eq(TenderDocument::getProjectApprovalType, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
            List objs = this.tenderDocumentManager.listObjs((Wrapper)tenderDocumentQW);
            if (BeanUtils.isNotEmpty((Object)objs) && objs.size() > 0) {
                List<String> tenderIds = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                this.tenderDocumentManager.removeByIds(tenderIds);
            }
            LambdaQueryWrapper approvalInviteVendorQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId, (Object)entity.getId())).eq(ApprovalInviteVendor::getProjectApprovalType, (Object)2);
            this.approvalInviteVendorManager.remove((Wrapper)approvalInviteVendorQW);
            LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
            qualificationLabelQW.eq(MatApprovalQualification::getProjectId, (Object)entity.getId());
            this.approvalQualificationManager.remove((Wrapper)qualificationLabelQW);
            LambdaQueryWrapper evaTemplateQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaTemplateQW.eq(BizEvaluationSystem::getNoticeId, (Object)entity.getId())).eq(BizEvaluationSystem::getNoticeType, (Object)2)).orderByDesc(BizEvaluationSystem::getPreparedTime)).last("limit 1");
            BizEvaluationSystem bizEvaluationSystem = (BizEvaluationSystem)((Object)this.evaluationSystemManager.getBaseMapper().selectOne((Wrapper)evaTemplateQW));
            if (BeanUtils.isNotEmpty((Object)((Object)bizEvaluationSystem))) {
                LambdaQueryWrapper evaTemplateDetailQW = new LambdaQueryWrapper();
                evaTemplateDetailQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)bizEvaluationSystem.getId());
                this.evaluationSystemDescriptionManager.remove((Wrapper)evaTemplateDetailQW);
            }
            this.evaluationSystemManager.remove((Wrapper)evaTemplateQW);
            LambdaQueryWrapper payInfoQW = new LambdaQueryWrapper();
            payInfoQW.eq(ProjectApprovalPay::getNoticeId, (Object)entity.getId());
            this.payInfoManager.remove((Wrapper)payInfoQW);
        }
        if (BeanUtils.isNotEmpty(evaluationExpertList)) {
            entity.setEvaluationExpertNumber(evaluationExpertList.size());
        }
        if (BeanUtils.isEmpty((Object)entity.getQuotationRoundsNum())) {
            entity.setQuotationRoundsNum(1);
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            ArrayList<ProjectApprovalPay> payInfoDataList = new ArrayList<ProjectApprovalPay>();
            for (ProjectApprovalDetails s2 : detailList) {
                List<ProjectApprovalPay> payInfoList = s2.getPayInfoList();
                s2.setNoticeId(entity.getId());
                s2.setNoticeCode(entity.getNoticeCode());
                s2.setNoticeTitle(entity.getNoticeTitle());
                this.detailsManager.save((Object)s2);
                if (!BeanUtils.isNotEmpty(payInfoList) || payInfoList.size() <= 0) continue;
                payInfoList.forEach(p -> {
                    p.setNoticeId(entity.getId());
                    p.setNoticeCode(entity.getNoticeCode());
                    p.setNoticeTitle(entity.getNoticeTitle());
                    p.setNoticeDetailId(s2.getId());
                });
                payInfoDataList.addAll(payInfoList);
            }
            if (payInfoDataList.size() > 0) {
                this.payInfoManager.saveBatch(payInfoDataList);
            }
        }
        if (BeanUtils.isNotEmpty(quotationTemplateDetailApprovalList) && quotationTemplateDetailApprovalList.size() > 0) {
            quotationTemplateDetailApprovalList.stream().forEach(s -> {
                s.setId(null);
                s.setProjectApprovalType(2);
                s.setNoticeId(entity.getId());
            });
            this.quotationTemplateDetailApprovalManager.saveBatch(quotationTemplateDetailApprovalList);
        }
        if (BeanUtils.isEmpty(evaluationExpertList) || evaluationExpertList.size() <= 0) {
            evaluationExpertList = new ArrayList<ProjectEvaluationExpert>();
            ProjectEvaluationExpert temp = new ProjectEvaluationExpert();
            IUser currentUser = ContextUtil.getCurrentUser();
            temp.setEvaluatorType(3);
            temp.setExpertId(currentUser.getUserId());
            temp.setFullname(currentUser.getFullname());
            temp.setAccount(currentUser.getAccount());
            evaluationExpertList.add(temp);
        }
        if (evaluationExpertList.size() > 0) {
            evaluationExpertList.stream().forEach(s -> {
                s.setId(null);
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(2);
            });
            this.evaluationExpertManager.saveBatch(evaluationExpertList);
        }
        ArrayList<Accessory> accessoryData = new ArrayList<Accessory>();
        if (BeanUtils.isNotEmpty((Object)((Object)zbDocument))) {
            List<Accessory> accessoryList = zbDocument.getAccessoryList();
            zbDocument.setProjectApprovalType(2);
            zbDocument.setProjectApprovalId(entity.getId());
            this.tenderDocumentManager.save((Object)zbDocument);
            accessoryList.stream().forEach(accessory -> accessory.setSourceId(zbDocument.getId()));
            accessoryData.addAll(accessoryList);
        }
        this.accessoryService.saveBatch(accessoryData);
        if (BeanUtils.isNotEmpty(approvalInviteVendorList) && approvalInviteVendorList.size() > 0) {
            approvalInviteVendorList.stream().forEach(s -> {
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(2);
            });
            this.approvalInviteVendorManager.saveBatch(approvalInviteVendorList);
        }
        if (BeanUtils.isNotEmpty(matApprovalQualificationList) && matApprovalQualificationList.size() > 0) {
            matApprovalQualificationList.stream().forEach(s -> s.setProjectId(entity.getId()));
            this.approvalQualificationManager.saveBatch(matApprovalQualificationList);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)evaTemplate))) {
            evaTemplate.setNoticeId(entity.getId());
            evaTemplate.setNoticeType(2);
            ProjectLedger projectLedger = (ProjectLedger)((Object)this.projectLedgerManager.getById((Serializable)((Object)entity.getProjectLedgerId())));
            if (projectLedger.getProjectType() == 1) {
                evaTemplate.setEvaType(3);
            } else {
                evaTemplate.setEvaType(4);
            }
            evaTemplate.setPreparedOrgId(ContextUtil.getCurrentOrgId());
            evaTemplate.setPreparedTime(LocalDateTime.now());
            List<BizEvaluationSystemDescription> descriptionList = evaTemplate.getDescriptionList();
            this.evaluationSystemManager.save((Object)evaTemplate);
            descriptionList.stream().forEach(s -> s.setEvaluationSystemId(evaTemplate.getId()));
            this.evaluationSystemDescriptionManager.saveBatch(descriptionList);
            LambdaUpdateWrapper projectApprovalUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)projectApprovalUW.set(ProjectApproval::getEvaluationTemplateId, (Object)evaTemplate.getId())).eq(ProjectApproval::getId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            super.update((Wrapper)projectApprovalUW);
        }
        return entity;
    }

    @Override
    @Transactional
    public void uploadTenderDoc(ProjectApproval entity) {
        List<TenderDocument> byDocumentList = entity.getByDocument();
        if (BeanUtils.isNotEmpty(byDocumentList) && byDocumentList.size() > 0) {
            for (TenderDocument byDocument : byDocumentList) {
                List<Accessory> accessoryList = byDocument.getAccessoryList();
                if (!BeanUtils.isNotEmpty(accessoryList) || accessoryList.size() <= 0) continue;
                byDocument.setProjectApprovalType(2);
                byDocument.setType(2);
                byDocument.setReleaseStatus(1);
                byDocument.setProjectApprovalId(entity.getId());
                this.tenderDocumentManager.save((Object)byDocument);
                accessoryList.stream().forEach(accessory -> accessory.setSourceId(byDocument.getId()));
                this.accessoryService.saveBatch(accessoryList);
            }
        }
    }

    @Override
    @Transactional
    public void modifyBidStatus(String ids, String status) {
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getBidStatus, (Object)status)).in(ProjectApproval::getId, Arrays.asList(ids.split(",")))).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void modifyReleaseStatus(String ids, String status) {
        LocalDateTime nowTime = LocalDateTime.now();
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getReleaseStatus, (Object)status)).in(ProjectApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        if (status.equals("2")) {
            ((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getBidStatus, (Object)3)).set(ProjectApproval::getNoticeReleaseTime, (Object)nowTime);
        }
        if (status.equals("3")) {
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.in(UserParticipation::getNoticeId, idList)).notIn(UserParticipation::getStatus, Arrays.asList("5,6"))).eq(BizModel::getIsDele, (Object)"0");
            if (this.userParticipationManager.count((Wrapper)userParticipationQW) > 0) {
                throw new BaseException("\u5df2\u6709\u7528\u6237\u53c2\u4e0e\u62a5\u540d\uff0c\u4e0b\u67b6\u5931\u8d25");
            }
            ((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getBidStatus, (Object)2)).set(ProjectApproval::getNoticeOffTime, (Object)LocalDateTime.now());
        }
        super.update((Wrapper)approvalUW);
        if (status.equals("2")) {
            LambdaQueryWrapper matApprovalQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)matApprovalQW.in(ProjectApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
            List approvalList = super.list((Wrapper)matApprovalQW);
            List cglxDic = this.sysDictionaryManager.queryDictListItemsByCode("cglx-cglx");
            for (ProjectApproval notice : approvalList) {
                String noticeRedisKey = "matApproval:" + notice.getId();
                long endTime = notice.getResponseTimeDeadline().toEpochSecond(ZoneOffset.of("+8"));
                long currentTime = nowTime.toEpochSecond(ZoneOffset.of("+8"));
                this.redisUtil.set(noticeRedisKey, (Object)0, endTime - currentTime - 60L);
                this.redisUtil.set("backups" + noticeRedisKey, (Object)0);
                try {
                    PushNoticeVO mhNoticeVO = new PushNoticeVO();
                    mhNoticeVO.setProjectCode(notice.getNoticeCode());
                    mhNoticeVO.setContent(notice.getEstablishmentName());
                    mhNoticeVO.setNoticeTitle(notice.getNoticeTitle());
                    mhNoticeVO.setAffCompany(notice.getProcureOrgName());
                    if (notice.getProcureType() == 2) {
                        mhNoticeVO.setNoticeType(2);
                    } else if (notice.getProcureType() == 4) {
                        mhNoticeVO.setNoticeType(3);
                    } else {
                        mhNoticeVO.setNoticeType(1);
                    }
                    if (notice.getApplicationType() == 1) {
                        mhNoticeVO.setCategory(3);
                    } else {
                        mhNoticeVO.setCategory(4);
                    }
                    mhNoticeVO.setReleaseTime(notice.getNoticeReleaseTime());
                    mhNoticeVO.setStartRegistrationTime(notice.getNoticeReleaseTime());
                    mhNoticeVO.setEndRegistrationTime(notice.getResponseTimeDeadline());
                    mhNoticeVO.setStartAuctionTime(notice.getBiddingStartTime());
                    mhNoticeVO.setEndAuctionTime(notice.getBiddingEndTime());
                    mhNoticeVO.setStatus(1);
                    mhNoticeVO.setDetailedUrl(this.cgptPushNoticeUrl + notice.getId());
                    this.foreignCallService.pushNoticeToMh(mhNoticeVO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u7acb\u9879\u516c\u544a\u53d1\u5e03\u5230\u95e8\u6237\u5931\u8d25\uff1a" + e.getMessage());
                }
                String wxResult = "";
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    String s = notice.getProcureType().toString();
                    String cglxStr = BizUtils.getDicValueByCode((List<DictModel>)cglxDic, s);
                    WxNoticeTemplate wxTemplate = new WxNoticeTemplate(notice.getProcureOrgName(), notice.getNoticeTitle(), cglxStr, notice.getNoticeReleaseTime().format(formatter));
                    wxTemplate.setTemplateId(this.wxNoticeTemplateId);
                    wxResult = this.foreignCallService.pushWxMessage(wxTemplate).toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    wxResult = e.getMessage();
                }
                finally {
                    System.out.println("\u63a8\u9001\u7acb\u9879\u516c\u544a\u5230\u5fae\u4fe1\u516c\u4f17\u53f7\uff1a" + wxResult);
                }
            }
        }
    }

    @Override
    @Transactional
    public void modifyCalibraStatus(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        List approvalList = super.listByIds(idList);
        Integer evaStatus = null;
        evaStatus = status.equals("1") ? Integer.valueOf(2) : (status.equals("2") ? Integer.valueOf(3) : Integer.valueOf(1));
        for (ProjectApproval approval : approvalList) {
            List evaList;
            QueryFilter evaQF;
            if (approval.getEvaluationMethod() == 1) {
                evaQF = QueryFilter.build();
                evaQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                evaQF.addFilter("a.NOTICE_ID_", (Object)approval.getId(), QueryOP.EQUAL);
                evaList = this.bidEvaluationManager.getCalibraDetailByIdPro((QueryFilter<BizBidEvaluation>)evaQF).getRows();
                LambdaUpdateWrapper evaUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)evaUW.set(BizBidEvaluation::getStatus, (Object)evaStatus)).in(BizBidEvaluation::getNoticeId, idList)).eq(BizBidEvaluation::getNoticeType, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
                this.bidEvaluationManager.update((Wrapper)evaUW);
                continue;
            }
            if (approval.getEvaluationMode() == 1) {
                evaQF = QueryFilter.build();
                evaQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                evaQF.addFilter("a.NOTICE_ID_", (Object)approval.getId(), QueryOP.EQUAL);
                evaList = this.bidEvaluationManager.getCalibraDetailComprehensive((QueryFilter<BizBidEvaluation>)evaQF).getRows();
                Integer finalEvaStatus = evaStatus;
                evaList.stream().forEach(s -> s.setStatus(finalEvaStatus));
                this.bidEvaluationManager.updateBatchById(evaList);
                continue;
            }
            List<BizBidEvaluation> evaList2 = this.bidEvaluationManager.getCalibraDetailMaxScoreById(approval.getId());
            Integer finalEvaStatus = evaStatus;
            evaList2.stream().forEach(s -> s.setStatus(finalEvaStatus));
            this.bidEvaluationManager.updateBatchById(evaList2);
        }
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getCalibraStatus, (Object)status)).in(ProjectApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
    }

    @Override
    public PageList<ProjectApproval> signData(QueryFilter<ProjectApproval> queryFilter) {
        IPage<ProjectApproval> result;
        List records;
        Integer joinStatus = 0;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equals("joinStatus")) continue;
                if ((Integer)qf.getValue() == 1) {
                    joinStatus = 1;
                }
                qf.setProperty("1");
                qf.setValue((Object)"1");
            }
        }
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        ArrayList<String> noticeIds = new ArrayList<String>();
        QueryWrapper userPartNoticeQW = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userPartNoticeQW.select(new String[]{"DISTINCT NOTICE_ID_"}).lambda().eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeType, (Object)2)).eq(UserParticipation::getStatus, (Object)1)).eq(UserParticipation::getType, (Object)1)).eq(BizModel::getIsDele, (Object)0);
        if (joinStatus == 1) {
            List noticeIdObjs = this.userParticipationManager.listObjs((Wrapper)userPartNoticeQW);
            if (BeanUtils.isNotEmpty((Object)noticeIdObjs) && noticeIdObjs.size() > 0) {
                noticeIds.addAll(noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
        } else {
            List<String> list = ((ProjectApprovalDao)this.baseMapper).queryIds((Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
            if (BeanUtils.isEmpty(list) || list.size() <= 0) {
                return new PageList(new ArrayList());
            }
            userPartNoticeQW.lambda().in(UserParticipation::getNoticeId, list);
            List noticeIdObjs = this.userParticipationManager.listObjs((Wrapper)userPartNoticeQW);
            if (BeanUtils.isNotEmpty((Object)noticeIdObjs) && noticeIdObjs.size() > 0) {
                list.removeAll(noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            noticeIds.addAll(list);
        }
        if (noticeIds.size() > 0) {
            queryFilter.addFilter("ID_", noticeIds, QueryOP.IN, FieldRelation.OR, "yq");
        }
        if (BeanUtils.isNotEmpty((Object)(records = (result = ((ProjectApprovalDao)this.baseMapper).queryAllByPage((IPage<ProjectApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()))).getRecords())) && records.size() > 0) {
            if (joinStatus == 1) {
                records.forEach(s -> s.setJoinStatus(1));
            } else {
                for (ProjectApproval notice : records) {
                    LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeType, (Object)2)).eq(UserParticipation::getNoticeId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)0);
                    List partList = this.userParticipationManager.list((Wrapper)userParticipationQW);
                    if (BeanUtils.isNotEmpty((Object)partList) && partList.size() > 0) {
                        List collect = partList.stream().filter(s -> s.getStatus() == 2).map(s -> s.getId()).collect(Collectors.toList());
                        if (BeanUtils.isNotEmpty(collect) && collect.size() > 0) {
                            notice.setJoinStatus(2);
                            notice.setPartId((String)collect.get(0));
                            continue;
                        }
                        List collect1 = partList.stream().filter(s -> s.getStatus() == 3).map(s -> s.getId()).collect(Collectors.toList());
                        if (BeanUtils.isNotEmpty(collect1) && collect1.size() > 0) {
                            notice.setJoinStatus(3);
                            notice.setPartId((String)collect1.get(0));
                            continue;
                        }
                        List collect2 = partList.stream().filter(s -> s.getStatus() == 5).map(s -> s.getId()).collect(Collectors.toList());
                        if (BeanUtils.isNotEmpty(collect2) && collect2.size() > 0) {
                            notice.setJoinStatus(5);
                            notice.setPartId((String)collect2.get(0));
                            continue;
                        }
                        List collect3 = partList.stream().filter(s -> s.getStatus() == 6).map(s -> s.getId()).collect(Collectors.toList());
                        if (BeanUtils.isNotEmpty(collect3) && collect3.size() > 0) {
                            notice.setJoinStatus(6);
                            notice.setPartId((String)collect3.get(0));
                            continue;
                        }
                        notice.setJoinStatus(1);
                        notice.setPartId(((UserParticipation)((Object)partList.get(0))).getId());
                        continue;
                    }
                    notice.setJoinStatus(0);
                }
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<ProjectApproval> quoData(QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("notice.RELEASE_STATUS_", (Object)"2", QueryOP.EQUAL);
        queryFilter.addFilter("notice.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("notice.BID_STATUS_", (Object)"3", QueryOP.EQUAL);
        queryFilter.addFilter("part.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("part.NOTICE_TYPE_", (Object)2, QueryOP.EQUAL);
        queryFilter.addFilter("part.STATUS_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("part.TYPE_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("part.COMPANY_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("notice.BIDDING_END_TIME_", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL);
        IPage<ProjectApproval> result = ((ProjectApprovalDao)this.baseMapper).getQuoData((IPage<ProjectApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            records.stream().forEach(s -> {
                LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)quoQW.eq(BizBiddingQuotation::getQuotationRounds, (Object)s.getQuotationRoundsNum())).eq(BizBiddingQuotation::getNoticeId, (Object)s.getId())).eq(BizBiddingQuotation::getNoticeType, (Object)2)).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)ContextUtil.getCurrentOrgId());
                if (this.quotationManager.count((Wrapper)quoQW) > 0) {
                    s.setIsQuo(1);
                } else {
                    s.setIsQuo(0);
                }
            });
        }
        return new PageList(result);
    }

    @Override
    public PageList<ProjectApproval> quoManageData(QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("RELEASE_STATUS_", (Object)"2", QueryOP.EQUAL);
        if (BizUtils.isAdmin(this.ucFeignService)) {
            queryFilter.addFilter("AFFILIATED_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL, FieldRelation.OR, "org");
            queryFilter.addFilter("PROCURE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL, FieldRelation.OR, "org");
            QueryWrapper quoQW = new QueryWrapper();
            ((LambdaQueryWrapper)quoQW.select(new String[]{"DISTINCT NOTICE_ID_"}).lambda().eq(BizBiddingQuotation::getQuotationCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(BizBiddingQuotation::getNoticeType, (Object)2);
            List quoNoticeIdsObj = this.quotationManager.listObjs((Wrapper)quoQW);
            if (BeanUtils.isNotEmpty((Object)quoNoticeIdsObj) && quoNoticeIdsObj.size() > 0) {
                List collect = quoNoticeIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                queryFilter.addFilter("ID_", collect, QueryOP.IN, FieldRelation.OR, "org");
            }
        }
        IPage<ProjectApproval> result = ((ProjectApprovalDao)this.baseMapper).queryAllByPage((IPage<ProjectApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<ProjectApproval> bidOpenData(QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("RELEASE_STATUS_", (Object)"2", QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        BizUtils.addFilterByUserOrgAndRole(queryFilter, this.ucFeignService, "AFFILIATED_ORG_ID_");
        IPage<ProjectApproval> result = ((ProjectApprovalDao)this.baseMapper).queryAllByPage((IPage<ProjectApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void openingBid(ProjectApproval entity) {
        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
        if (BeanUtils.isNotEmpty(evaluationExpertList) && evaluationExpertList.size() > 0) {
            LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)entity.getId())).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)2);
            this.evaluationExpertManager.remove((Wrapper)evaluationExpertQW);
            evaluationExpertList.stream().forEach(s -> {
                s.setId(null);
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(2);
            });
            this.evaluationExpertManager.saveBatch(evaluationExpertList);
        }
        BizBidOpening bidOpening = new BizBidOpening();
        bidOpening.setOperateType(1);
        bidOpening.setOperateTime(LocalDateTime.now());
        bidOpening.setOperateUserId(ContextUtil.getCurrentUserId());
        bidOpening.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        bidOpening.setOperateUserName(ContextUtil.getCurrentUserName());
        bidOpening.setQuotationRounds(entity.getQuotationRoundsNum());
        bidOpening.setOperateMethod(1);
        bidOpening.setNoticeId(entity.getId());
        bidOpening.setNoticeType(2);
        bidOpening.setNoticeCode(entity.getNoticeCode());
        bidOpening.setOperateUserName(entity.getNoticeTitle());
        bidOpening.setEvaluationMethod(entity.getEvaluationMethod());
        this.bidOpeningManager.save((Object)bidOpening);
        Integer noticeStatus = 5;
        LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
        quoQW.eq(BizBiddingQuotation::getNoticeId, (Object)entity.getId());
        if (this.quotationManager.count((Wrapper)quoQW) == 0) {
            noticeStatus = 8;
            LambdaUpdateWrapper approvalDetailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalDetailUW.set(ProjectApprovalDetails::getBidStatus, (Object)6)).eq(ProjectApprovalDetails::getNoticeId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            this.detailsManager.update((Wrapper)approvalDetailUW);
        }
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getBidStatus, (Object)noticeStatus)).set(BeanUtils.isNotEmpty((Object)entity.getEvaluationMethod()), ProjectApproval::getEvaluationMethod, (Object)entity.getEvaluationMethod()).set(ProjectApproval::getEvaluationStartTime, (Object)bidOpening.getOperateTime())).eq(ProjectApproval::getId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
    }

    @Override
    @Transactional
    public void newRoundQuo(ProjectApproval entity) {
        ProjectApproval notice = (ProjectApproval)((Object)super.getById((Serializable)((Object)entity.getId())));
        BizBidOpening bidOpening = new BizBidOpening();
        Integer roundsNum = BeanUtils.isNotEmpty((Object)notice.getQuotationRoundsNum()) ? notice.getQuotationRoundsNum() : 1;
        if (entity.getBidStatus() == 3) {
            if (notice.getBidStatus() != 5 && notice.getBidStatus() != 6) {
                throw new BaseException("\u5f53\u524d\u9879\u76ee\u72b6\u6001\u65e0\u6cd5\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7");
            }
            if (BeanUtils.isNotEmpty((Object)notice.getCalibraStatus()) && notice.getCalibraStatus() != 0) {
                throw new BaseException("\u5df2\u53d1\u8d77\u5b9a\u6807\u5ba1\u6279\uff0c\u65e0\u6cd5\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7");
            }
            notice.setBiddingStartTime(entity.getBiddingStartTime());
            notice.setBiddingEndTime(entity.getBiddingEndTime());
            notice.setQuotationRoundsNum(roundsNum + 1);
            if (BeanUtils.isNotEmpty((Object)entity.getNewQuoReason())) {
                notice.setNewQuoReason(entity.getNewQuoReason());
                bidOpening.setRemarks(entity.getNewQuoReason());
            }
            bidOpening.setOperateType(3);
        } else if (entity.getBidStatus() == 8) {
            if (BeanUtils.isNotEmpty((Object)notice.getCalibraStatus()) && notice.getCalibraStatus() != 0) {
                throw new BaseException("\u5df2\u53d1\u8d77\u5b9a\u6807\u5ba1\u6279\uff0c\u65e0\u6cd5\u6d41\u6807");
            }
            if (BeanUtils.isNotEmpty((Object)entity.getFailBidReason())) {
                notice.setFailBidReason(entity.getFailBidReason());
                bidOpening.setRemarks(entity.getFailBidReason());
            }
            bidOpening.setOperateType(2);
        }
        notice.setBidStatus(entity.getBidStatus());
        super.updateById((Object)notice);
        bidOpening.setOperateTime(LocalDateTime.now());
        bidOpening.setOperateUserId(ContextUtil.getCurrentUserId());
        bidOpening.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        bidOpening.setOperateUserName(ContextUtil.getCurrentUserName());
        bidOpening.setQuotationRounds(roundsNum);
        bidOpening.setOperateMethod(1);
        bidOpening.setNoticeId(notice.getId());
        bidOpening.setNoticeType(2);
        bidOpening.setNoticeCode(notice.getNoticeCode());
        bidOpening.setOperateUserName(notice.getNoticeTitle());
        bidOpening.setEvaluationMethod(notice.getEvaluationMethod());
        this.bidOpeningManager.save((Object)bidOpening);
    }

    @Override
    public PageList<ProjectApproval> bidEvaData(QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List<String> idList = ((ProjectApprovalDao)this.baseMapper).queryIds((Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (BeanUtils.isEmpty(idList) || idList.size() <= 0) {
            return new PageList(this.convert2IPage(queryFilter.getPageBean()));
        }
        QueryWrapper evaExpertQW = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaExpertQW.select(new String[]{"distinct PROJECT_APPROVAL_ID_"}).lambda().eq(ProjectEvaluationExpert::getAccount, (Object)ContextUtil.getCurrentUserAccount())).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)"2")).in(ProjectEvaluationExpert::getProjectApprovalId, idList)).eq(BizModel::getIsDele, (Object)"0");
        List noticeIdObjs = this.evaluationExpertManager.listObjs((Wrapper)evaExpertQW);
        if (BeanUtils.isEmpty((Object)noticeIdObjs) || noticeIdObjs.size() <= 0) {
            return new PageList();
        }
        List noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
        queryFilter.addFilter("ID_", noticeIds, QueryOP.IN);
        IPage<ProjectApproval> result = ((ProjectApprovalDao)this.baseMapper).queryAllByPage((IPage<ProjectApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void releaseWinBidNotice(String id) throws Exception {
        ProjectApproval approval = (ProjectApproval)((Object)super.getById((Serializable)((Object)id)));
        approval.setBidStatus(11);
        super.updateById((Object)approval);
        LambdaQueryWrapper calibraQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)calibraQW.eq(Calibration::getNoticeId, (Object)id)).eq(Calibration::getNoticeType, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
        List calibraList = this.calibraManager.list((Wrapper)calibraQW);
        if (BeanUtils.isNotEmpty((Object)calibraList) && calibraList.size() > 0) {
            ArrayList<BizWinBiddingNoticeDetaile> winNoticeDetailList = new ArrayList<BizWinBiddingNoticeDetaile>();
            for (Calibration ca : calibraList) {
                BizWinBiddingNotice winNotice = new BizWinBiddingNotice();
                BeanUtils.copyNotNullProperties((Object)((Object)winNotice), (Object)((Object)ca));
                winNotice.setId(null);
                winNotice.setProcureOrgId(approval.getProcureOrgId());
                winNotice.setProcureOrgCode(approval.getProcureOrgCode());
                winNotice.setProcureOrgName(approval.getProcureOrgName());
                winNotice.setSendTime(LocalDateTime.now());
                winNotice.setStatus(1);
                this.winBidNoticeManager.save((Object)winNotice);
                LambdaQueryWrapper caDetailQW = new LambdaQueryWrapper();
                caDetailQW.eq(CalibrationDetail::getCalibrationId, (Object)ca.getId());
                List caDetailList = this.calibraDetailManager.list((Wrapper)caDetailQW);
                if (!BeanUtils.isNotEmpty((Object)caDetailList) || caDetailList.size() <= 0) continue;
                for (CalibrationDetail caDetail : caDetailList) {
                    BizWinBiddingNoticeDetaile winNoticeDetail = new BizWinBiddingNoticeDetaile();
                    BeanUtils.copyNotNullProperties((Object)((Object)winNoticeDetail), (Object)((Object)caDetail));
                    winNoticeDetail.setId(null);
                    winNoticeDetail.setWinNoticeId(winNotice.getId());
                    winNoticeDetail.setApplicationMethod(approval.getProcureType());
                    winNoticeDetail.setIsTax(approval.getIsTax());
                    winNoticeDetail.setStatus(1);
                    winNoticeDetailList.add(winNoticeDetail);
                }
            }
            if (winNoticeDetailList.size() > 0) {
                this.winBidNoticeDetailManager.saveBatch(winNoticeDetailList);
            }
        }
    }

    @Override
    public ProjectApproval getInfoByIdAndUserId(String id, String userId) {
        List orgList;
        ProjectApproval result = (ProjectApproval)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.eq(TenderDocument::getProjectApprovalId, (Object)id)).eq(TenderDocument::getProjectApprovalType, (Object)2)).eq(TenderDocument::getReleaseStatus, (Object)2)).isNotNull(TenderDocument::getType)).eq(BizModel::getIsDele, (Object)"0");
        List documentList = this.tenderDocumentManager.list((Wrapper)tenderDocumentQW);
        if (BeanUtils.isNotEmpty((Object)documentList) && documentList.size() > 0) {
            List<TenderDocument> byDocument;
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
            List<TenderDocument> zbDocument = collect.get(1);
            if (BeanUtils.isNotEmpty(zbDocument) && zbDocument.size() > 0) {
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(this.accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }
            if (BeanUtils.isNotEmpty(byDocument = collect.get(2)) && byDocument.size() > 0) {
                byDocument.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
                result.setByDocument(byDocument);
            }
        }
        result.setJoinStatus(0);
        if (BeanUtils.isNotEmpty((Object)userId) && BeanUtils.isNotEmpty((Object)(orgList = this.orgManager.getOrgListByUserId(userId))) && orgList.size() > 0) {
            String orgId = ((Org)orgList.get(0)).getId();
            List orgIds = orgList.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getIsMaster()) && s.getIsMaster() == 1).map(s -> s.getId()).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(orgIds) && orgIds.size() > 0) {
                orgId = (String)orgIds.get(0);
            }
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getCompanyId, (Object)orgId)).eq(UserParticipation::getNoticeType, (Object)2)).eq(UserParticipation::getNoticeId, (Object)result.getId())).eq(BizModel::getIsDele, (Object)0)).last("limit 1");
            UserParticipation participation = (UserParticipation)((Object)this.userParticipationManager.getBaseMapper().selectOne((Wrapper)userParticipationQW));
            if (BeanUtils.isNotEmpty((Object)((Object)participation)) && BeanUtils.isNotEmpty((Object)participation.getStatus())) {
                result.setJoinStatus(participation.getStatus());
            }
        }
        return result;
    }
}

