package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商黑名单，本表有附件
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizSupplierOrgBlacklist对象", description="供应商黑名单，本表有附件")
@TableName("biz_supplier_org_blacklist")
@Data
public class BizSupplierOrgBlacklist extends BizModel<BizSupplierOrgBlacklist> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "采购商ID")
    @TableField("PURCHASER_ORG_ID_")
    private String purchaserOrgId;

    @ApiModelProperty(value = "采购商编号")
    @TableField("PURCHASER_CODE_")
    private String purchaserCode;

    @ApiModelProperty(value = "采购商名称")
    @TableField("PURCHASER_NAME_")
    private String purchaserName;

    @ApiModelProperty(value = "加入黑名单时间")
    @TableField("BLACKLIST_START_DATE_")
    private LocalDate blacklistStartDate;

    @ApiModelProperty(value = "黑名单到期时间（默认两年）")
    @TableField("BLACKLIST_EXPIRE_DATE_")
    private LocalDate blacklistExpireDate;

    @ApiModelProperty(value = "加入黑名单原因")
    @TableField("BLACKLIST_REASON_")
    private String blacklistReason;

    @ApiModelProperty(value = "黑名单类型（1：个体，2：全部）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "状态（0：启用，1：禁用）")
    @TableField("BLACKLIST_STATUS_")
    private Integer blacklistStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "附件信息")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

}
