package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商_企业关联表（准入供应商）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
@ApiModel(value="BizSupplierEnterprise对象", description="供应商_企业关联表（准入供应商）")
@TableName("biz_supplier_enterprise")
@Data
public class BizSupplierEnterprise extends BizModel<BizSupplierEnterprise> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商ID（关联组织表ID）")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "企业ID（关联组织表ID）")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "类型（1.准入供应商，2.临时供应商）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "供应商分类表ID（关联供应商分类表ID）")
    @TableField("SUPPLIER_TYPE_ID_")
    private String supplierTypeId;

    @ApiModelProperty(value = "供应商分类编码")
    @TableField("CATEGORY_CODE_")
    private String categoryCode;

    @ApiModelProperty(value = "供应商分类名称")
    @TableField("CATEGORY_NAME_")
    private String categoryName;

    @ApiModelProperty(value = "供应商级别级别（1：A级，2：B级，3：C级，4：D级）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "是否需要供应商上传资质（0：否，1：是），默认0")
    @TableField("NEED_PROVIDE_QUALIFICATIONS_")
    private Integer needProvideQualifications;

    @ApiModelProperty(value = "审核状态（0：未审核（已下发），1.审核中（已上传资质），2.已审核，3.驳回，4.草稿），默认4")
    @TableField("REVIEW_STATUS_")
    private Integer reviewStatus;

    @ApiModelProperty(value = "资质类型编码")
    @TableField("QUALIFICATIONS_CODE_")
    private String qualificationsCode;

    @ApiModelProperty(value = "准入配置ID")
    @TableField("ADMISSION_CONFIG_ID_")
    private String admissionConfigId;

    @ApiModelProperty(value = "准入配置编码")
    @TableField("ADMISSION_CONFIG_CODE_")
    private String admissionConfigCode;

    @ApiModelProperty(value = "供应商税号")
    @TableField(exist = false)
    private String companyOrgcode;

    @ApiModelProperty(value = "资质附件")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "资质类型集合")
    @TableField(exist = false)
    private List<AdmittedSuppliersQualification> suppliersQualificationList;

    @ApiModelProperty(value = "供应商集合")
    @TableField(exist = false)
    private List<Org> supplierList;

    @ApiModelProperty(value = "多个分类")
    @TableField(exist = false)
    private List<String> supplierTypeIds;

    @ApiModelProperty(value = "资质库集合")
    @TableField(exist = false)
    private List<BizQualificationLabel> qualificationLabelList;

}
