package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @Description:准入供应商资质要求关联表
 * @Author: Rong Tao
 * @Date: 2024/6/19 15:42
 */
@ApiModel(value="AdmittedSuppliersQualification对象", description="准入供应商资质要求关联表")
@TableName("biz_admitted_suppliers_qualification")
@Data
public class AdmittedSuppliersQualification extends BizNoModel<AdmittedSuppliersQualification> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入供应商表ID")
    @TableField("ADMITTED_SUPPLIER_ID_")
    private String admittedSupplierId;

    @ApiModelProperty(value = "资质类型表ID")
    @TableField("QUALIFICATION_CATEGORY_ID_")
    private String qualificationCategoryId;

    @ApiModelProperty(value = "资质类别编码")
    @TableField("QUALIFICATION_CATEGORY_CODE_")
    private String qualificationCategoryCode;

    @ApiModelProperty(value = "资质类别名称")
    @TableField("QUALIFICATION_CATEGORY_NAME_")
    private String qualificationCategoryName;

    @ApiModelProperty(value = "资质限制文件大小（MB），空或者0表示不限制")
    @TableField("FILE_SIZE_")
    private Integer fileSize;

    @ApiModelProperty(value = "资质限制文件数量，空或者0表示不限制")
    @TableField("FILE_NUM_")
    private Integer fileNum;

    @ApiModelProperty(value = "有效截止期")
    @TableField("EXPIRY_DATE_")
    private LocalDate expiryDate;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

}
