package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:准入配置资质要求关联表
 * @Author: Rong Tao
 * @Date: 2024/7/11 10:48
 */
@ApiModel(value="AdmissionConfigQualification对象", description="准入配置资质要求关联表")
@TableName("biz_admission_config_qualification")
@Data
public class AdmissionConfigQualification extends BizNoModel<AdmissionConfigQualification> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入配置表ID")
    @TableField("ADMISSION_CONFIG_ID_")
    private String admissionConfigId;

    @ApiModelProperty(value = "资质类型表ID")
    @TableField("QUALIFICATION_CATEGORY_ID_")
    private String qualificationCategoryId;

    @ApiModelProperty(value = "是否必传（0.否，1.是），默认1")
    @TableField("NECESSARY_STATUS_")
    private Integer necessaryStatus;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;


    @ApiModelProperty(value = "企业id")
    @TableField(exist = false)
    private String enterpriseId;
    @ApiModelProperty(value = "企业编码")
    @TableField(exist = false)
    private String enterpriseCode;
    @ApiModelProperty(value = "企业名称")
    @TableField(exist = false)
    private String enterpriseName;
    @ApiModelProperty(value = "资质类型编码")
    @TableField(exist = false)
    private String code;
    @ApiModelProperty(value = "资质类型名称")
    @TableField(exist = false)
    private String name;
    @ApiModelProperty(value = "资质限制文件大小")
    @TableField(exist = false)
    private String fileSize;
    @ApiModelProperty(value = "资质限制文件数量")
    @TableField(exist = false)
    private String fileNum;

}
