package com.artfess.cgpt.supplier.manager.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.supplier.dao.EnterpriseDao;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.*;
import com.artfess.uc.model.*;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/6 10:05
 */
@Service
public class EnterpriseManagerImpl extends BaseManagerImpl<EnterpriseDao, Enterprise> implements EnterpriseManager {

    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private RoleManager roleManager;
    @Autowired
    private BizSupplierEnterpriseManager supplierEnterpriseManager;

    @Override
    public PageList<Org> queryOrgNoOccupy(QueryFilter<Enterprise> queryFilter) {
        //过滤当前企业
        String groupCode = ContextUtil.getCurrentGroup().getGroupCode();
        if(BeanUtils.isEmpty(groupCode)){
            return new PageList<>(new ArrayList<>());
        }

        List<String> orgCodes = new ArrayList<>();
        orgCodes.add(groupCode);
        //1.过滤掉已添加占用供应商和临时供应商的组织
        LambdaQueryWrapper<BizSupplierEnterprise> supplierEnterpriseQW = new LambdaQueryWrapper<>();
        supplierEnterpriseQW.select(BizSupplierEnterprise::getSupplierCode)
                .eq(BizSupplierEnterprise::getEnterpriseCode, groupCode)
                .eq(BizSupplierEnterprise::getIsDele,"0");
        List<Object> objs = supplierEnterpriseManager.listObjs(supplierEnterpriseQW);
        if(BeanUtils.isNotEmpty(objs) && objs.size()>0){
            List<String> collect = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            orgCodes.addAll(collect);
        }
        queryFilter.addFilter("a.code_",orgCodes, QueryOP.NOT_IN);
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        IPage<Org> result = baseMapper.queryOrg(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<Org> queryAllOrg(QueryFilter<Enterprise> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        IPage<Org> result = baseMapper.queryOrg(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<Enterprise> queryByPage(QueryFilter<Enterprise> queryFilter) {
        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"COMPANY_CODE_");
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<Enterprise> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void saveOrUpdateEntity(Enterprise entity) {
        LambdaQueryWrapper<Enterprise> enterExistQW = new LambdaQueryWrapper<>();
        enterExistQW.and(s->s.eq(Enterprise::getCompanyName,entity.getCompanyName())
                        .or().eq(Enterprise::getCompanyOrgcode,entity.getCompanyOrgcode()))
                .eq(Enterprise::getIsDele,"0")
                .ne(BeanUtils.isNotEmpty(entity.getId()),Enterprise::getId,entity.getId());
        if(super.count(enterExistQW)>0) {
            throw new BaseException("企业名称或税号已存在");
        }

        if(BeanUtils.isEmpty(entity.getCompanyCode())){
            //如果企业编号为空
            //1.根据名称查询组织是否存在
            LambdaQueryWrapper<Org> orgQW = new LambdaQueryWrapper<>();
            orgQW.eq(Org::getName,entity.getCompanyName())
                    .eq(Org::getIsDelete,"0")
                    .orderByDesc(Org::getCreateTime)
                    .last("limit 1");
            Org org = orgManager.getBaseMapper().selectOne(orgQW);
            if(BeanUtils.isEmpty(org)){
                //不存在->添加组织，并设置企业表组织id和编码
                String orgId = "";
                String orgCode = BizUtils.getNextSerialNumber(systemConfigFeignService, "qygl_qybh");
                OrgVo orgVo = new OrgVo();
                orgVo.setCode(orgCode);
                orgVo.setDemId("1258608622670319616");
                orgVo.setExceedLimitNum(0);
                orgVo.setLimitNum(0);
                orgVo.setName(entity.getCompanyName());
                orgVo.setNowNum(0);
                orgVo.setOrgKind("ogn");
                orgVo.setParentId("0");
                CommonResult<String> stringCommonResult = null;
                try {
                    stringCommonResult = orgManager.addOrg(orgVo);
                } catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("添加组织失败："+e.getMessage());
                }
                if (BeanUtils.isNotEmpty(stringCommonResult)) {
                    String value = stringCommonResult.getValue();
                    if (BeanUtils.isNotEmpty(value)) {
                        JSONObject jsonObject = JSON.parseObject(value);
                        orgId = jsonObject.get("id").toString();
                    }
                }
                entity.setOrgId(orgId);
                entity.setCompanyOrgcode(orgCode);
            }else {
                //存在->设置企业表组织id和编码
                entity.setOrgId(org.getId());
                entity.setCompanyOrgcode(org.getCode());
            }
        }else {
            //如果企业编号不为空
            Org org = orgManager.getByCode(entity.getCompanyCode());
            if(BeanUtils.isNotEmpty(org)){
                if(!org.getName().equals(entity.getCompanyName())){
                    org.setName(entity.getCompanyName());
                    orgManager.updateById(org);
                }
                entity.setOrgId(org.getId());
            }else {
                //不存在->添加组织，并设置企业表组织id和编码
                String orgId = "";
                OrgVo orgVo = new OrgVo();
                orgVo.setCode(entity.getCompanyCode());
                orgVo.setDemId("1258608622670319616");
                orgVo.setExceedLimitNum(0);
                orgVo.setLimitNum(0);
                orgVo.setName(entity.getCompanyName());
                orgVo.setNowNum(0);
                orgVo.setOrgKind("ogn");
                orgVo.setParentId("0");
                CommonResult<String> stringCommonResult = null;
                try {
                    stringCommonResult = orgManager.addOrg(orgVo);
                } catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("添加组织失败："+e.getMessage());
                }
                if (BeanUtils.isNotEmpty(stringCommonResult)) {
                    String value = stringCommonResult.getValue();
                    if (BeanUtils.isNotEmpty(value)) {
                        JSONObject jsonObject = JSON.parseObject(value);
                        orgId = jsonObject.get("id").toString();
                    }
                }
                entity.setOrgId(orgId);
            }
        }

        super.saveOrUpdate(entity);
    }


    @Transactional
    public void saveOrUpdateEntityByApi(Enterprise entity) {
        Org org = orgManager.getByCode(entity.getCompanyCode());
        List<String> orgRoleTypeList = new ArrayList<>();
        if(BeanUtils.isNotEmpty(entity.getOrgRoleType())){
            orgRoleTypeList.addAll(Arrays.asList(entity.getOrgRoleType().split(",")));
        }else {
            orgRoleTypeList.add("1");
        }

        String grade = null;
        if(orgRoleTypeList.contains("0") && orgRoleTypeList.contains("1")){
            //既是买方又是买方
            grade="1004001";
        }else if(orgRoleTypeList.contains("0")){
            //买方
            grade="1001001";
        }else {
            //卖方
            grade="1003001";
        }

        if(BeanUtils.isNotEmpty(org)){
            org.setGrade(grade);
            org.setName(entity.getCompanyName());
            orgManager.updateById(org);
            entity.setOrgId(org.getId());
        }else {
            //不存在->添加组织，并设置企业表组织id和编码
            String orgId = "";
            OrgVo orgVo = new OrgVo();
            orgVo.setCode(entity.getCompanyCode());
            orgVo.setDemId("1258608622670319616");
            orgVo.setExceedLimitNum(0);
            orgVo.setLimitNum(0);
            orgVo.setName(entity.getCompanyName());
            orgVo.setNowNum(0);
            orgVo.setOrgKind("ogn");
            orgVo.setParentId("0");
            orgVo.setGrade(grade);
            CommonResult<String> stringCommonResult = null;
            try {
                stringCommonResult = orgManager.addOrg(orgVo);
            } catch (Exception e) {
                e.printStackTrace();
                System.out.println("添加组织失败："+e.getMessage());
            }
            if (BeanUtils.isNotEmpty(stringCommonResult)) {
                String value = stringCommonResult.getValue();
                if (BeanUtils.isNotEmpty(value)) {
                    JSONObject jsonObject = JSON.parseObject(value);
                    orgId = jsonObject.get("id").toString();
                }
            }
            entity.setOrgId(orgId);
        }

        //根据企业编号保存或更新数据
        LambdaQueryWrapper<Enterprise> enterpriseQW = new LambdaQueryWrapper<>();
        enterpriseQW.eq(Enterprise::getCompanyCode,entity.getCompanyCode())
                .eq(Enterprise::getIsDele,"0");
        super.saveOrUpdate(entity,enterpriseQW);

    }

    @Transactional
    public void saveOrUpdateUserByApi(UserVo userVo) throws Exception {
        userVo.setStatus(1);
        userVo.setId(null);
        userVo.setTenantId(null);
        String userId = "";
//        User user = new User();
//        BeanUtils.copyNotNullProperties(user,userVo);

        //根据用户账号保存或更新用户
        LambdaQueryWrapper<User> userQW = new LambdaQueryWrapper<>();
        userQW.eq(User::getAccount,userVo.getAccount())
                .eq(User::getIsDelete,"0")
                .last("limit 1");
        User userHis = userManager.getBaseMapper().selectOne(userQW);

        if(BeanUtils.isNotEmpty(userHis)){
            userId = userHis.getId();
            //如果已存在，更新用户
            userVo.setId(userHis.getId());
            userManager.updateUserById(userVo);
        }else {
            //不存在，设置初始密码新增
            userVo.setPassword("Spwz@"+userVo.getMobile());
            userId = userManager.addUser(userVo).getId();
        }

        //设置组织
        if(BeanUtils.isNotEmpty(userVo.getOrgCode())) {
            Org org = orgManager.getByCode(userVo.getOrgCode());
            if(BeanUtils.isEmpty(org)) {
                throw new BaseException("组织编号未找到");
            }

            OrgUser orgUser = orgUserManager.getOrgUser(org.getId(), userId, null);
            if (BeanUtils.isEmpty(orgUser)) {
                OrgUserVo orgUserVo = new OrgUserVo();
                orgUserVo.setAccount(userVo.getAccount());
                orgUserVo.setOrgCode(userVo.getOrgCode());
                orgUserVo.setIsMaster(1);
                orgManager.addOrgUser(orgUserVo);
            }else {
                orgUser.setIsMaster(1);
                orgUserManager.updateById(orgUser);
            }
        }

        //设置角色
        if(BeanUtils.isNotEmpty(userVo.getBusinessType())){
            List<String> roleList = new ArrayList<>();
//            roleList.add("ybyh");
            if(userVo.getBusinessType().equals("0")){
                //买方
                roleList.add("wzjp");
            }else if(userVo.getBusinessType().equals("1")){
                //卖方
                roleList.add("wzcz");
            }else {
                //两者都是
                roleList.add("wzjp");
                roleList.add("wzcz");
            }
            if(roleList.size()>0){
                roleManager.saveUserRoles(String.join(",",roleList),userVo.getAccount());
            }
        }

    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(cn.hutool.json.JSONObject param) {
        String code = "0";
        String message = "操作成功";
        String errDetail = "";
        try {
            List<Enterprise> data = JSONUtil.toList(param.getJSONArray("data"), Enterprise.class);
            for (Enterprise temp : data) {
                temp.setId(null);
                saveOrUpdateEntityByApi(temp);
            }
        }catch (Exception e){
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "操作失败:"+errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }

        return new Response<>(code, message, errDetail);
    }

    @Override
    @Transactional
    public Response saveOrUpdateUserByApi(cn.hutool.json.JSONObject param) {
        String code = "0";
        String message = "操作成功";
        String errDetail = "";
        try {
            List<UserVo> data = JSONUtil.toList(param.getJSONArray("data"), UserVo.class);
            for (UserVo temp : data) {
                saveOrUpdateUserByApi(temp);
            }
        }catch (Exception e){
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "操作失败:"+errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }

        return new Response<>(code, message, errDetail);
    }

    @Override
    public Enterprise getByOrgIdOrCode(String orgId, String orgCode) {
        LambdaQueryWrapper<Enterprise> enterpriseQW = new LambdaQueryWrapper<>();
        enterpriseQW.and(q -> q.eq(Enterprise::getOrgId, orgId).or()
                        .eq(Enterprise::getCompanyCode, orgCode))
                .eq(Enterprise::getIsDele, "0")
                .orderByDesc(Enterprise::getCreateTime).last("limit 1");
        return baseMapper.selectOne(enterpriseQW);
    }

    @Override
    public Enterprise getByCodeOrHisCode(String code) {
        LambdaQueryWrapper<Enterprise> enterpriseQW = new LambdaQueryWrapper<>();
        enterpriseQW.and(q -> q.eq(Enterprise::getCompanyCode, code).or()
                        .eq(Enterprise::getHistoryCompanyCode, code))
                .eq(Enterprise::getIsDele, "0")
                .orderByDesc(Enterprise::getCreateTime).last("limit 1");
        return baseMapper.selectOne(enterpriseQW);
    }

}
