package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.model.BizDeliveryAddress;
import com.artfess.cgpt.supplier.dao.BizDeliveryAddressDao;
import com.artfess.cgpt.supplier.manager.BizDeliveryAddressManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 送货地址管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wsf
 * @since 2024-06-21
 */
@Service
public class BizDeliveryAddressManagerImpl extends BaseManagerImpl<BizDeliveryAddressDao, BizDeliveryAddress> implements BizDeliveryAddressManager {

    @Autowired
    private SystemConfigFeignService systemConfigFeignService;

    @Override
    public void saveOrUpdateEntity(BizDeliveryAddress entity) {

        if(BeanUtils.isEmpty(entity.getId())){
            entity.setCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"shdz_dzbm"));
        }

        if(BeanUtils.isEmpty(entity.getDefaultStatus()) || entity.getDefaultStatus().equals(0)){
            //判断当前企业是否有默认地址
            LambdaQueryWrapper<BizDeliveryAddress> qw = new LambdaQueryWrapper<>();
            qw.eq(BizDeliveryAddress::getEnterpriseId, ContextUtil.getCurrentOrgId())
                    .eq(BizDeliveryAddress::getDefaultStatus,1)
                    .eq(BizDeliveryAddress::getIsDele,"0");
            if(super.count(qw)==0){
                //如果没有，更新为默认
                entity.setDefaultStatus(1);
            }
        }else {
            //更新其他地址为非默认
            LambdaUpdateWrapper<BizDeliveryAddress> uw = new LambdaUpdateWrapper<>();
            uw.set(BizDeliveryAddress::getDefaultStatus,0)
                    .eq(BizDeliveryAddress::getEnterpriseId, ContextUtil.getCurrentOrgId())
                    .ne(BizDeliveryAddress::getDefaultStatus,0)
                    .eq(BizDeliveryAddress::getIsDele,"0");
            super.update(uw);
        }

        super.saveOrUpdate(entity);
    }

    @Override
    public PageList<BizDeliveryAddress> queryByPage(QueryFilter<BizDeliveryAddress> queryFilter) {
        return super.query(queryFilter);
    }

}
