package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.supplier.dao.AdmissionConfigDao;
import com.artfess.cgpt.supplier.manager.AdmissionConfigManager;
import com.artfess.cgpt.supplier.manager.AdmissionConfigQualificationManager;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/6 10:52
 */
@Service
public class AdmissionConfigManagerImpl extends BaseManagerImpl<AdmissionConfigDao, AdmissionConfig> implements AdmissionConfigManager {

    @Autowired
    private AdmissionConfigQualificationManager configQualificationManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizMaterialCategoryManager matCategoryManager;

    //2024-08-05 17:11
//    @Override
//    @Transactional
//    public void saveOrUpdateEntity(AdmissionConfig entity) {
//        List<AdmissionConfigQualification> configQualificationList = entity.getConfigQualificationList();
//        IGroup org = ContextUtil.getCurrentGroup();
//        //查询该企业该分类是否存在数据
//        LambdaQueryWrapper<AdmissionConfig> hisQW = new LambdaQueryWrapper<>();
//        hisQW.eq(AdmissionConfig::getEnterpriseId,org.getGroupId())
//                .eq(AdmissionConfig::getMatCategoryId,entity.getMatCategoryId())
//                .ne(BeanUtils.isNotEmpty(entity.getId()),AdmissionConfig::getId,entity.getId());
//        if(super.count(hisQW)>0){
//            throw new BaseException("已存在该分类数据，无法重复添加");
//        }
//
//        if(BeanUtils.isEmpty(entity.getId())){
//            entity.setCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"zrgz_bm"));
//            entity.setEnterpriseId(org.getGroupId());
//            entity.setEnterpriseCode(org.getGroupCode());
//            entity.setEnterpriseName(org.getName());
//            entity.setAddUserId(ContextUtil.getCurrentUserId());
//            entity.setAddUserName(ContextUtil.getCurrentUserName());
//            entity.setAddTime(LocalDateTime.now());
//        }else {
//            LambdaQueryWrapper<AdmissionConfigQualification> configQualificationQW = new LambdaQueryWrapper<>();
//            configQualificationQW.eq(AdmissionConfigQualification::getAdmissionConfigId,entity.getId());
//            configQualificationManager.remove(configQualificationQW);
//        }
//
//        super.saveOrUpdate(entity);
//
//        if(BeanUtils.isNotEmpty(configQualificationList) && configQualificationList.size()>0){
//            configQualificationList.stream().forEach(s->s.setAdmissionConfigId(entity.getId()));
//            configQualificationManager.saveBatch(configQualificationList);
//        }
//
//    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(AdmissionConfig entity) {
        List<AdmissionConfigQualification> configQualificationList = entity.getConfigQualificationList();
        IGroup org = ContextUtil.getCurrentGroup();

        List<String> matCategoryIdList = Arrays.asList(entity.getMatCategoryId().split(","));

        //查询该企业该分类是否存在数据
        LambdaQueryWrapper<AdmissionConfig> hisQW = new LambdaQueryWrapper<>();
        if(BeanUtils.isNotEmpty(matCategoryIdList) && matCategoryIdList.size()>0){
            for(String cateId : matCategoryIdList){
                hisQW.eq(AdmissionConfig::getEnterpriseId,org.getGroupId())
                        .like(AdmissionConfig::getMatCategoryId,cateId)
                        .ne(BeanUtils.isNotEmpty(entity.getId()),AdmissionConfig::getId,entity.getId());
                if(super.count(hisQW)>0){
                    BizMaterialCategory cate = matCategoryManager.getById(cateId);
                    throw new BaseException("已存在【"+cate.getName()+"】分类数据，无法重复添加");
                }
            }
        }

        if(BeanUtils.isEmpty(entity.getId())){
            if(BeanUtils.isEmpty(entity.getCode())){
                entity.setCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"zrgz_bm"));
            }

            entity.setEnterpriseId(org.getGroupId());
            entity.setEnterpriseCode(org.getGroupCode());
            entity.setEnterpriseName(org.getName());
            entity.setAddUserId(ContextUtil.getCurrentUserId());
            entity.setAddUserName(ContextUtil.getCurrentUserName());
            entity.setAddTime(LocalDateTime.now());
        }else {
            LambdaQueryWrapper<AdmissionConfigQualification> configQualificationQW = new LambdaQueryWrapper<>();
            configQualificationQW.eq(AdmissionConfigQualification::getAdmissionConfigId,entity.getId());
            configQualificationManager.remove(configQualificationQW);
        }

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(configQualificationList) && configQualificationList.size()>0){
            configQualificationList.stream().forEach(s->s.setAdmissionConfigId(entity.getId()));
            configQualificationManager.saveBatch(configQualificationList);
        }

    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(List<AdmissionConfig> data) {
        IGroup org = ContextUtil.getCurrentGroup();
        IUser user = ContextUtil.getCurrentUser();
        data.stream().forEach(entity->{
            if(BeanUtils.isEmpty(entity.getId())){
                entity.setEnterpriseId(org.getGroupId());
                entity.setEnterpriseCode(org.getGroupCode());
                entity.setEnterpriseName(org.getName());
                entity.setAddUserId(user.getUserId());
                entity.setAddUserName(user.getUsername());
                entity.setAddTime(LocalDateTime.now());
            }
        });
        super.saveOrUpdateBatch(data);
    }

    @Override
    @Transactional
    public void removeByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaQueryWrapper<AdmissionConfigQualification> configQualificationQW = new LambdaQueryWrapper<>();
        configQualificationQW.in(AdmissionConfigQualification::getAdmissionConfigId,idList);
        configQualificationManager.remove(configQualificationQW);
        super.removeByIds(idList);
    }

    @Override
    public PageList<AdmissionConfig> queryByPage(QueryFilter<AdmissionConfig> queryFilter) {
        IPage<AdmissionConfig> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<AdmissionConfig> queryQuaCategory(QueryFilter<AdmissionConfig> queryFilter) {
        IPage<AdmissionConfig> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        List<AdmissionConfig> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            records.stream().forEach(s->{
                s.setQualificationCategoryList(configQualificationManager.getQualificationCategoryByConfigId(s.getId()));
            });
        }
        return new PageList<>(result);
    }

    @Override
    public AdmissionConfig getDataById(String id) {
        AdmissionConfig result = super.getById(id);
        if(BeanUtils.isNotEmpty(result)){
            result.setQualificationCategoryList(configQualificationManager.getQualificationCategoryByConfigId(result.getId()));
        }
        return result;
    }

}
