package com.artfess.cgpt.supplier.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/6 10:51
 */
public interface AdmissionConfigManager extends BaseManager<AdmissionConfig> {

    /**
     * 保存或更新数据
     * @param entity
     * @return
     */
    void saveOrUpdateEntity(AdmissionConfig entity);

    /**
     * 批量保存或更新数据
     * @param data
     * @return
     */
    void saveOrUpdateEntity(List<AdmissionConfig> data);

    /**
     * 根据id删除数据
     * @param ids
     */
    void removeByIds(String ids);

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<AdmissionConfig> queryByPage(QueryFilter<AdmissionConfig> queryFilter);

    /**
     * 分页查询数据（包含资质分类）
     * @param queryFilter
     * @return
     */
    PageList<AdmissionConfig> queryQuaCategory(QueryFilter<AdmissionConfig> queryFilter);

    /**
     * 根据id查询
     * @param id
     */
    AdmissionConfig getDataById(String id);

}
