package com.artfess.cgpt.supplier.dao;

import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizSupplierOrgDao extends BaseMapper<BizSupplierOrg> {

    IPage<BizSupplierOrg> queryAllByPage(IPage<BizSupplierOrg> convert2IPage, @Param("ew")Wrapper<BizSupplierOrg> convert2Wrapper);

    List<BizSupplierType> querySupplierType(@Param("ew")String supplierId);

    List<BizQualificationLabel> queryQualification(@Param("ew")String supplierId);
}
