package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.SupplierIssueManagementManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.SupplierEnterpriseAuditing;
import com.artfess.cgpt.supplier.model.SupplierIssueManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

/**
 * @Description:供应商问题管理表
 * @Author: Rong Tao
 * @Date: 2024/6/19 19:00
 */
@RestController
@RequestMapping("/supplierIssueManagement/v1/")
@Api(tags="供应商问题管理表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class SupplierIssueManagementController extends BaseController<SupplierIssueManagementManager, SupplierIssueManagement> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<SupplierIssueManagement>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<SupplierIssueManagement> queryFilter){
        PageList<SupplierIssueManagement> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody SupplierIssueManagement entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/updateHandleStatus")
    @ApiOperation("更新处理状态")
    public CommonResult updateHandleStatus(@RequestBody SupplierIssueManagement entity) {
        baseService.updateHandleStatus(entity);
        return new CommonResult(true,"操作成功");
    }

    @GetMapping("getById/{id}")
    @ApiOperation("根据id查询详情")
    public SupplierIssueManagement getDetailById(@PathVariable String id) {
        return baseService.getDetailById(id);
    }

}
