package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.supplier.model.BizSupplierTypeEvaluation;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeEvaluationManager;

import java.util.Arrays;

/**
 * 供应商分类评级标准表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
@RestController
@RequestMapping("/supplier/bizSupplierTypeEvaluation/v1/")
@Api(tags="供应商分类评级标准")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierTypeEvaluationController extends BaseController<BizSupplierTypeEvaluationManager, BizSupplierTypeEvaluation> {

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody BizSupplierTypeEvaluation entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizSupplierTypeEvaluation> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizSupplierTypeEvaluation> queryFilter) {
        return baseService.query(queryFilter);
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询供应商分类评级标准")
    public BizSupplierTypeEvaluation getById(@ApiParam(name="id", value="供应商分类评级标准id") @PathVariable String id) {
        return baseService.getById(id);
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="供应商分类评级标准id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除供应商分类评级标准失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="供应商分类评级标准集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除供应商分类评级标准失败");
        }
        return new CommonResult<>();
    }
}
