package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.cgpt.receipt.model.BizReconciliationDetail;
import com.artfess.cgpt.receipt.dao.BizReconciliationDetailDao;
import com.artfess.cgpt.receipt.manager.BizReconciliationDetailManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * 对账单明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizReconciliationDetailManagerImpl extends BaseManagerImpl<BizReconciliationDetailDao, BizReconciliationDetail> implements BizReconciliationDetailManager {


    @Override
    public List<BizReconciliationDetail> getByPid(String recId) {
        LambdaQueryWrapper<BizReconciliationDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BizReconciliationDetail::getRecId,recId);
        return super.list(wrapper);
    }

    @Override
    @Transactional
    public void removeByPid(String recId) {
        List<String> recIds = Arrays.asList(recId.split(","));
        LambdaQueryWrapper<BizReconciliationDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BizReconciliationDetail::getRecId,recIds);
        super.remove(wrapper);
    }

}
