package com.artfess.cgpt.receipt.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.model.ArrivalDetail;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:28
 */
public interface ArrivalDetailManager extends BaseManager<ArrivalDetail> {

    /**
     * 根据发货单id查询详情
     * @param arrivalId
     * @return
     */
    List<ArrivalDetail> getByArrivalId(String arrivalId);

    /**
     * 根据发货单id删除明细
     * @param arrivalId
     */
    void removeByArrivalId(String arrivalId);

    ArrivalDetail getDetail(String id);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<ArrivalDetail> queryAllPage(QueryFilter<ArrivalDetail> queryFilter);

}
