package com.artfess.cgpt.receipt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.receipt.manager.ArrivalManager;
import com.artfess.cgpt.receipt.model.Arrival;
import com.artfess.cgpt.receipt.model.BizReceipt;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:采购发货单表
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:21
 */
@RestController
@RequestMapping("/arrival/v1/")
@Api(tags = "采购发货单表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ArrivalController extends BaseController<ArrivalManager,Arrival> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<Arrival>> queryAllByPage(@RequestBody QueryFilter<Arrival> queryFilter){
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        PageList<Arrival> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<Arrival> selectOne(@RequestParam("id") String id){
        Arrival result = baseService.getDetailById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-根据id批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult save(@RequestBody Arrival entity) {
        String id = baseService.saveVo(entity);
        return new CommonResult<>(true, "操作成功",id);
    }

    @PostMapping("/updateStatus")
    @ApiOperation(value = "M-根据id修改状态")
    public CommonResult updateStatus(@RequestParam("id") String id,@RequestParam("status") Integer status){
        baseService.updateStatus(id,status);
        return new CommonResult<>(true,"操作成功",id);
    }

    @PostMapping("/pageVendorGroup")
    @ApiOperation(value = "M-分页查询供应商分组")
    public CommonResult<PageList<Arrival>> pageVendorGroup(@RequestBody QueryFilter<Arrival> queryFilter){
        PageList<Arrival> result = baseService.pageVendorGroup(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
