package com.artfess.cgpt.purchasing.vo;

import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Description:采购立项明细导入
 * @Author: Rong Tao
 * @Date: 2024/8/14 10:06
 */
@Data
public class MatApprovalDetailsImportVO {

    @Excel(name = "*需求企业编号")
    private String matCompanyCode;

    private String matCompanyName;

    @Excel(name = "*平台物料编号")
    private String matPlatcode;
    @Excel(name = "*数量")
    private BigDecimal matNum;
    @Excel(name = "最高限价(元)")
    private BigDecimal maximumPriceLimit;

    private LocalDate demandDate;
    @Excel(name = "*需求日期")
    private String demandDateValue;

    @Excel(name = "*计划编号")
    private String planCode;
    @Excel(name = "送货地址")
    private String unloadAddress;
    @Excel(name = "企业补充说明")
    private String remarks;


    private String matCategoryCode;
    private String matCode;

}
