package com.artfess.cgpt.purchasing.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/6/26 11:05
 */
@Data
public class MatApprovalDetailsExportVO implements Serializable {

    @Excel(name = "标的ID")
    private String id;

    @Excel(name = "标的编号")
    private String matPlatcode;

    @Excel(name = "标的名称")
    private String matName;

    @Excel(name = "物料牌号")
    private String matMaterial;

    @Excel(name = "规格型号")
    private String matSpec;

    @Excel(name = "计量单位")
    private String matUnit;

    @Excel(name = "交货地址")
    private String unloadAddress;

    @Excel(name = "基础扩展")
    private String matBaseExt;

    @Excel(name = "其他扩展")
    private String matOtherExt;

    @Excel(name = "预计需求数量")
    private BigDecimal matNum;

    @Excel(name = "需求单位")
    private String matCompanyName;

    @Excel(name = "企业补充说明")
    private String remarks;

    @Excel(name = "计划编号")
    private String planCode;
    @Excel(name = "最高限价(元)")
    private BigDecimal maximumPriceLimit;


    private String matBrand;
    private String noticeTitle;
    private String noticeNumber;
    private Integer quotationRounds;
    private String matCompanyCode;
    private LocalDate demandDate;
    private String demandDateValue;
    private String matCategoryCode;
}
