package com.artfess.cgpt.purchasing.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购订单明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@ApiModel(value="BizPurchaseOrderDetail对象", description="采购订单明细表")
@TableName("biz_purchase_order_detail")
@Data
public class BizPurchaseOrderDetail extends BizNoModel<BizPurchaseOrderDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购订单ID")
    @TableField("ORDER_ID_")
    private String orderId;

    @ApiModelProperty(value = "采购订单编号")
    @TableField("ORDER_CODE_")
    private String orderCode;

    @ApiModelProperty(value = "物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;


    @ApiModelProperty(value = "合同明细ID")
    @TableField("CONTRACT_ITEM_ID_")
    private String contractItemId;

    @ApiModelProperty(value = "采购申请ID(关联采购申请表ID)")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "采购申请明细ID(关联采购申请表ID)")
    @TableField("PURCHASING_APPLICATION_DETAIL_ID_")
    private String purchasingApplicationDetailId;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "物料分类编号")
    @TableField("MAT_CATEGORY_")
    private String matCategory;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "不含税单价")
    @TableField("ORDER_PRICE_")
    private BigDecimal orderPrice;

    @ApiModelProperty(value = "不含税金额")
    @TableField("ORDER_AMOUNT_")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "含税单价")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税金额")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

    @ApiModelProperty(value = "税额")
    @TableField("TAX_VALUE_")
    private BigDecimal taxValue;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;


    @ApiModelProperty(value = "供应商补充说明")
    @TableField("VENDOR_NOTE_")
    private String vendorNote;

    @ApiModelProperty(value = "交货期")
    @TableField("REQ_DATE_")
    private LocalDate reqDate;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("PUR_NOTE_")
    private String purNote;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    private String planCode;

}
