package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:立项邀请供应商表
 * @Author: Rong Tao
 * @Date: 2024/4/11 16:42
 */
@ApiModel(value="ApprovalInviteVendor对象", description="立项邀请供应商表")
@TableName("biz_approval_invite_vendor")
@Data
public class ApprovalInviteVendor extends BizNoModel<ApprovalInviteVendor> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("PROJECT_APPROVAL_ID_")
    private String projectApprovalId;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("PROJECT_APPROVAL_TYPE_")
    private Integer projectApprovalType;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编号")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

}
