package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.dao.TenderDocumentDao;
import com.artfess.cgpt.purchasing.manager.TenderDocumentConfirmManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import com.artfess.cgpt.purchasing.model.TenderDocumentConfirm;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 19:11
 */
@Service
public class TenderDocumentManagerImpl extends BaseManagerImpl<TenderDocumentDao, TenderDocument> implements TenderDocumentManager {

    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private TenderDocumentConfirmManager tenderDocumentConfirmManager;

    @Override
    public Boolean queryConfirmStatus(String noticeId) {
        LambdaQueryWrapper<TenderDocument> tdQW = new LambdaQueryWrapper<>();
        tdQW.select(TenderDocument::getId)
                .eq(TenderDocument::getIsDele,"0")
                .eq(TenderDocument::getProjectApprovalId,noticeId)
                .eq(TenderDocument::getReleaseStatus,2)
                .eq(TenderDocument::getIsVendorConfirm,2)
                .eq(TenderDocument::getType,2);
        List<Object> objList = super.listObjs(tdQW);

        if(BeanUtils.isNotEmpty(objList) && objList.size()>0){
            List<String> collect = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());

            //查询供应商文件确认表是否还存在未确认的
            LambdaQueryWrapper<TenderDocumentConfirm> confirmQW = new LambdaQueryWrapper<>();
            confirmQW.in(TenderDocumentConfirm::getTenderDocumentId,collect)
                    .eq(TenderDocumentConfirm::getVendorId, ContextUtil.getCurrentOrgId());
            int count = tenderDocumentConfirmManager.count(confirmQW);
            if(count!=collect.size()){
                return false;
            }
        }

        return true;
    }

    @Override
    public Boolean queryConfirmStatus(QueryFilter<TenderDocument> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<TenderDocument> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            List<String> collect = records.stream().map(s -> s.getId()).collect(Collectors.toList());

            //查询供应商文件确认表是否还存在未确认的
            LambdaQueryWrapper<TenderDocumentConfirm> confirmQW = new LambdaQueryWrapper<>();
            confirmQW.in(TenderDocumentConfirm::getTenderDocumentId,collect)
                    .eq(TenderDocumentConfirm::getVendorId, ContextUtil.getCurrentOrgId());
            int count = tenderDocumentConfirmManager.count(confirmQW);
            if(count!=collect.size()){
                return false;
            }
        }

        return true;
    }

    @Override
    public PageList<TenderDocument> queryAllByPage(QueryFilter<TenderDocument> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<TenderDocument> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<TenderDocument> pageAccessory(QueryFilter<TenderDocument> queryFilter) {
        String orgId = ContextUtil.getCurrentOrgId();
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<TenderDocument> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<TenderDocument> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(TenderDocument td : records){
                td.setAccessoryList(accessoryService.getAccessoryBySourceId(td.getId()));
                td.setConfirmStatus(0);

                if(td.getIsVendorConfirm()==2 && BeanUtils.isNotEmpty(orgId)){
                    //如果需要供应商确认

                    //根据当前供应商id和补遗文件id查询是否确认
                    LambdaQueryWrapper<TenderDocumentConfirm> confirmQW = new LambdaQueryWrapper<>();
                    confirmQW.eq(TenderDocumentConfirm::getVendorId,orgId)
                            .eq(TenderDocumentConfirm::getTenderDocumentId,td.getId());
                    if(tenderDocumentConfirmManager.count(confirmQW)>0){
                        td.setConfirmStatus(1);
                    }
                }

            }
        }

        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void modifyReleaseStatus(String ids, String status) {
        LambdaUpdateWrapper<TenderDocument> tenderUW = new LambdaUpdateWrapper<>();
        tenderUW.set(TenderDocument::getReleaseStatus,status)
                .in(TenderDocument::getId, Arrays.asList(ids.split(",")));
        super.update(tenderUW);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
//        LambdaQueryWrapper<TenderDocument> tenderQW = new LambdaQueryWrapper<>();
//        tenderQW.eq(TenderDocument::getReleaseStatus,1)
//                .in(TenderDocument::getId, ids);
//        super.remove(tenderQW);
        super.removeByIds(ids);
        accessoryService.removeBySourceIds(ids);
    }

    @Override
    @Transactional
    public void uploadByDoc(List<TenderDocument> docList) {
        if(BeanUtils.isNotEmpty(docList) && docList.size()>0){
            for(TenderDocument byDocument : docList){
                List<Accessory> accessoryList = byDocument.getAccessoryList();
                if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
                    byDocument.setType(2);
                    byDocument.setReleaseStatus(1);
                    super.save(byDocument);
                    accessoryList.stream().forEach(accessory->{
                        accessory.setSourceId(byDocument.getId());
                    });
                    accessoryService.saveBatch(accessoryList);
                }
            }
        }

    }

}
