package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.ClarifyAnswerManager;
import com.artfess.cgpt.purchasing.model.ClarifyAnswer;
import com.artfess.cgpt.purchasing.model.ClarifyQuestions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:澄清回答，有附件
 * @Author: Rong Tao
 * @Date: 2024/6/24 17:28
 */
@RestController
@RequestMapping("/clarifyAnswer/v1/")
@Api(tags="澄清回答")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ClarifyAnswerController extends BaseController<ClarifyAnswerManager, ClarifyAnswer> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ClarifyAnswer>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ClarifyAnswer> queryFilter) {
        PageList<ClarifyAnswer> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdate(@RequestBody ClarifyAnswer entity){
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true,"操作成功");
    }

}
