package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:设备项目明细表
 * @Author: Rong Tao
 * @Date: 2024/5/21 16:19
 */
@ApiModel(value="EquipmentProjectDetail对象", description="设备项目明细表")
@TableName("biz_equipment_project_detail")
@Data
public class EquipmentProjectDetail extends BizNoModel<EquipmentProjectDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目台账表ID")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "项目编号（关联项目库编号）")
    @TableField("PROJECT_LEDGER_CODE_")
    private String projectLedgerCode;

    @ApiModelProperty(value = "设备库ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号（图号）")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "税率")
    @TableField("MAT_TAXRATE_")
    private Integer matTaxrate;

    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField("EQUIPMENT_CLASSIFICATION_")
    private Integer equipmentClassification;

    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField("TECHNICAL_REQUIREMENT_")
    private String technicalRequirement;

    @ApiModelProperty(value = "不含税单价（元）")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税总额（元）")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税单价（元）")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税总额（元）")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "单台估价（万元）")
    @TableField("SINGLE_VALUATION_")
    private BigDecimal singleValuation;

    @ApiModelProperty(value = "总估价（万元）")
    @TableField("TOTAL_VALUATION_")
    private BigDecimal totalValuation;

    @ApiModelProperty(value = "制造者")
    @TableField("MANUFACTURER_")
    private String manufacturer;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "责任人ID")
    @TableField("PERSON_LIABLE_ID_")
    private String personLiableId;

    @ApiModelProperty(value = "责任人姓名")
    @TableField("PERSON_LIABLE_NAME_")
    private String personLiableName;

    @ApiModelProperty(value = "责任人联系方式")
    @TableField("PERSON_LIABLE_PHONE_")
    private String personLiablePhone;

}
