package com.artfess.cgpt.project.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.project.manager.UserParticipationManager;

/**
 * 参与报名表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Api(tags="参与报名")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RestController
@RequestMapping("/userParticipation/v1/")
public class UserParticipationController extends BaseController<UserParticipationManager, UserParticipation> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<UserParticipation>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<UserParticipation> queryFilter) {
        PageList<UserParticipation> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getDataById")
    @ApiOperation(value = "M-根据id查询详情")
    public CommonResult<UserParticipation> getDataById(@RequestParam("id") String id) {
        UserParticipation result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询当前公司数据")
    public CommonResult<PageList<UserParticipation>> queryByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<UserParticipation> queryFilter) {
        PageList<UserParticipation> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageRegistraAndBid")
    @ApiOperation(value = "M-分页查询所有数据及投标情况")
    public CommonResult<PageList<UserParticipation>> pageRegistraAndBid(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<UserParticipation> queryFilter) {
        PageList<UserParticipation> result = baseService.pageRegistraAndBid(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/participate")
    @ApiOperation(value = "M-参与（无资质）")
    public CommonResult participate(@RequestBody UserParticipation entity) {
        baseService.participate(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/qualificationsParticipate")
    @ApiOperation(value = "M-参与（有资质）")
    public CommonResult qualificationsParticipate(@RequestBody UserParticipation entity) {
        String id = baseService.qualificationsParticipate(entity);
        return new CommonResult<>(true, "操作成功",id);
    }

    @PostMapping("/modifyStatus")
    @ApiOperation(value = "M-修改参与状态")
    public CommonResult modifyStatus(@RequestParam("ids") String ids,
                                        @RequestParam("status") String status){
        baseService.modifyStatus(ids,status);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/modifyStatusByNoticeId")
    @ApiOperation(value = "M-根据立项id修改当前组织参与状态")
    public CommonResult modifyStatusByNoticeId(@RequestParam("noticeIds") String noticeIds,
                                     @RequestParam("status") String status){
        baseService.modifyStatusByNoticeId(noticeIds,status);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/refundWinBidBond")
    @ApiOperation(value = "M-退还成交供应商保证金")
    public CommonResult refundWinBidBond(){
        baseService.refundWinBidBond();
        return new CommonResult<>(true,"操作成功");
    }


}
