package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.ProjectInfoDetailManager;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.ProjectInfoDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:项目基本信息明细表
 * @Author: Rong Tao
 * @Date: 2024/3/27 18:12
 */
@RestController
@RequestMapping("/projectInfoDetail/v1/")
@Api(tags="项目基本信息明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectInfoDetailController extends BaseController<ProjectInfoDetailManager, ProjectInfoDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<ProjectInfoDetail>> queryAllByPage(@RequestBody QueryFilter<ProjectInfoDetail> queryFilter) {
        PageList<ProjectInfoDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
