package com.artfess.cgpt.order.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizUserApplicationMatDetails;
import com.artfess.cgpt.order.dao.BizUserApplicationMatDetailsDao;
import com.artfess.cgpt.order.manager.BizUserApplicationMatDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用户报名订单物料明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Service
public class BizUserApplicationMatDetailsManagerImpl extends BaseManagerImpl<BizUserApplicationMatDetailsDao, BizUserApplicationMatDetails> implements BizUserApplicationMatDetailsManager {
    @Autowired
    private UCFeignService ucFeignService;
    @Override
    public PageList<BizUserApplicationMatDetails> queryAllByPage(QueryFilter<BizUserApplicationMatDetails> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizUserApplicationMatDetails> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }
}
