package com.artfess.cgpt.order.manager;

import cn.hutool.json.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.project.model.UserParticipation;

/**
 * 订单表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface BizRegistrationOrderManager extends BaseManager<BizRegistrationOrder> {

    /**
     * 根据id查询（不加租户过滤）
     * @param id
     * @return
     */
    BizRegistrationOrder getByIdNoTenant(String id);

    PageList<BizRegistrationOrder> queryAllByPage(QueryFilter<BizRegistrationOrder> queryFilter);

    BizRegistrationOrder getDetailById(String id);

    void saveVo(BizRegistrationOrder entity);

    /**
     * 获取当前公司余额（支付平台）
     * @return
     */
    JSONObject getCurrentAccount();

    /**
     * 付款（支付平台）
     * @param trans
     * @return
     */
    void payByBalance(BizRegistrationOrder trans);

    /**
     * 退还保证金
     * @param userPart
     */
    void refundBond(UserParticipation userPart);

}
