package com.artfess.cgpt.order.controller;


import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.order.model.BizUserApplicationMatDetails;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.order.model.BizUserApplicationProjectDetails;
import com.artfess.cgpt.order.manager.BizUserApplicationProjectDetailsManager;

import java.util.List;

/**
 * 用户报名订单项目明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@RestController
@RequestMapping("/bizUserApplicationProjectDetails/v1/")
public class BizUserApplicationProjectDetailsController extends BaseController<BizUserApplicationProjectDetailsManager, BizUserApplicationProjectDetails> {
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizUserApplicationProjectDetails>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizUserApplicationProjectDetails> queryFilter){
        PageList<BizUserApplicationProjectDetails> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizUserApplicationProjectDetails> selectOne(@RequestParam String id){
        BizUserApplicationProjectDetails result=baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody BizUserApplicationProjectDetails entity) {
        String message = "操作成功";
        baseService.saveOrUpdate(entity);

        return new CommonResult<>(true, message);
    }
}
