package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:渝企采政府采购品目分类表
 * @Author: Rong Tao
 * @Date: 2024/6/13 14:55
 */
@ApiModel(value="yqcGovernmentCategory对象", description="渝企采政府采购品目分类表")
@Data
@TableName("biz_yqc_government_category")
public class YqcGovernmentCategory extends BizModel<YqcGovernmentCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "父级ID")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "父级CODE")
    @TableField("PARENT_CODE_")
    private String parentCode;

    @ApiModelProperty(value = "分类编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "分类名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "状态（0：禁用，1：启用）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("NOTES_")
    private String notes;

    @ApiModelProperty(value = "排序号（自动生成）")
    @TableField("SN_")
    private Long sn;

}
