package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物料分级管理表
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
@ApiModel(value="BizMaterialHierarchicalManagement对象", description="物料分级管理表")
@Data
@TableName("biz_material_hierarchical_management")
public class MaterialHierarchicalManagement extends BizModel<MaterialHierarchicalManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "别名（可暂时不用）")
    @TableField("MAT_SHORT_NAME_")
    private String matShortName;

    @ApiModelProperty(value = "物料类型（1：平台物料，2：企业物料）")
    @TableField("MAT_TYPE_")
    private Integer matType;

    @ApiModelProperty(value = "物料ID（关联物料表ID）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "物料编码（关联物料表CODE）")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "父级ID（本表ID）")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "父级物料ID（顶级为root）")
    @TableField("PARENT_MAT_ID_")
    private String parentMatId;

    @ApiModelProperty(value = "父级物料CODE（顶级为root）")
    @TableField("PARENT_MAT_CODE_")
    private String parentMatCode;

    @ApiModelProperty(value = "创建企业ID）")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "创建企业编码")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "创建企业名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "备注")
    @TableField("NOTES_")
    private String notes;

    @ApiModelProperty(value = "应用企业集合")
    @TableField(exist = false)
    private List<MaterialHierarchicalManagementRange> materialHierarchicalManagementRangelList;

    @ApiModelProperty(value = "排序号（自动生成）")
    @TableField("SN_")
    private Long sn;


}
