package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.manager.YqcGovernmentCategoryManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.YqcGovernmentCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/6/13 15:02
 */
@RestController
@RequestMapping("/yqcGovernmentCategory/v1/")
@Api(tags="渝企采政府采购品目分类表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class YqcGovernmentCategoryController extends BaseController<YqcGovernmentCategoryManager, YqcGovernmentCategory> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<YqcGovernmentCategory>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<YqcGovernmentCategory> queryFilter){
        PageList<YqcGovernmentCategory> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
