package com.artfess.cgpt.material.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.bytebuddy.implementation.bytecode.Throw;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.manager.BizMaterialManager;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
@RestController
@RequestMapping("/bizMaterial/v1/")
@Api(tags="企业物料库")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMaterialController extends BaseController<BizMaterialManager, BizMaterial> {

    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private EnterpriseManager enterpriseManager;

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizMaterial>> queryByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizMaterial> queryFilter){
        BizUtils.addFilterByHisOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_CODE_",enterpriseManager);
        PageList<BizMaterial> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/pageCurOrgData")
    @ApiOperation(value = "M-分页查询当前公司数据")
    public CommonResult<PageList<BizMaterial>> pageCurOrgData(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizMaterial> queryFilter){
        IGroup org = ContextUtil.getCurrentGroup();
        if(BeanUtils.isEmpty(org)){
            return new CommonResult<>(true,"查询成功",new PageList<>());
        }
        Enterprise enterprise = enterpriseManager.getByOrgIdOrCode(org.getGroupId(),org.getGroupCode());
        queryFilter.addFilter("MAT_COMPANY_CODE_", org.getGroupCode(), QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
        if(BeanUtils.isNotEmpty(enterprise)){
            if(BeanUtils.isNotEmpty(enterprise.getHistoryCompanyCode())){
                queryFilter.addFilter("MAT_COMPANY_CODE_", enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
            }
        }
        PageList<BizMaterial> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BizMaterial>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizMaterial> queryFilter){
        PageList<BizMaterial> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-根据id查询详情")
    public CommonResult<BizMaterial> selectOne(@RequestParam("id") String id){
        BizMaterial result = baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/save")
    @ApiOperation(value = "M-添加或修改物料")
    public CommonResult save(@RequestBody BizMaterial material) {
        String message = "操作成功";

        if(material.getMatType()==2){
            //设备
            //查询企业和物料编号是否存在数据
            LambdaQueryWrapper<BizMaterial> wrapper = new LambdaQueryWrapper();
            wrapper.eq(BizMaterial::getMatType,2)
                    .eq(BizMaterial::getMatCode, material.getMatCode())
                    .eq(BizMaterial::getMatCompanyId,material.getMatCompanyId());
            if (baseService.count(wrapper) > 0) {
                throw new BaseException("企业下已存在相同设备编号，请修改后重试");
            }
        }

        baseService.saveOrUpdate(material);

        return new CommonResult<>(true, message);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除物料")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/exportExcelData")
    @ApiOperation(value = "M-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要")
    public CommonResult exportExcelData(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizMaterial> queryFilter, HttpServletResponse response) throws Exception {
        baseService.exportExcelData(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    @PostMapping(value = "/updateMatCategory")
    @ApiOperation(value = "M-根据id集合修改物料分类")
    public CommonResult updateMatCategory(@RequestBody List<String> ids, @RequestParam String categoryCode) {
        if(BeanUtils.isEmpty(ids) || ids.size()<=0){
            throw new BaseException("请选择物料");
        }
        baseService.updateMatCategory(ids,categoryCode);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping(value = "/updateMatStatus")
    @ApiOperation(value = "M-修改物料状态")
    public CommonResult updateMatStatus(@RequestBody List<String> ids,@RequestParam String status) {
        if(BeanUtils.isEmpty(ids) || ids.size()<=0){
            throw new BaseException("请选择物料");
        }
        baseService.updateMatStatus(ids,status);
        return new CommonResult<>(true, "操作成功");
    }

}
