package com.artfess.cgpt.foreignApi.vo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/3 18:48
 */
@Data
public class PushNoticeVO implements Serializable {
    /**
     * 公告编号
     */
    private String projectCode;
    /**
     * 公告内容
     */
    private String content;
    /**
     * 公告标题
     */
    private String noticeTitle;
    /**
     * 所属公司
     */
    private String affCompany;
    /**
     * 公告类型（1.公开采购，2.询价采购，3.竞争性谈判，4.物资竞价，5.澄清补遗，6.中选公示）
     */
    private Integer noticeType;
    /**
     * 所属类别（1.物资，2.货物，3.服务，4.工程）
     */
    private Integer category;
    /**
     * 发布时间(yyyy-MM-dd hh:mm:ss)
     */
    private LocalDateTime releaseTime;
    /**
     * 下架时间（状态为下架时必填）(yyyy-MM-dd hh:mm:ss)
     */
    private LocalDateTime offTime;
    /**
     * 开始报名时间(yyyy-MM-dd hh:mm:ss)
     */
    private LocalDateTime startRegistrationTime;
    /**
     * 结束报名时间(yyyy-MM-dd hh:mm:ss)
     */
    private LocalDateTime endRegistrationTime;
    /**
     * 开标时间（开始竞价时间）(yyyy-MM-dd hh:mm:ss)
     */
    private LocalDateTime startAuctionTime;
    /**
     * 结束时间（结束竞价时间）(yyyy-MM-dd hh:mm:ss)
     */
    private LocalDateTime endAuctionTime;
    /**
     * 公告详情URL（详情页面）
     */
    private String detailedUrl;
    /**
     * 移动端详情URL（详情页面）
     */
    private String mobileDetailedUrl;
    /**
     * 状态（1：已发布，2：已下架）
     */
    private Integer status;
}
