package com.artfess.cgpt.foreignApi.vo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Description:门户网站待办任务VO
 * @Author: Rong Tao
 * @Date: 2023/6/20 11:22
 */
@Data
public class MhTaskVO implements Serializable {
    /**
     * 标题
     */
    private String title;
    /**
     * 任务类型（1：待办事项、2： 消息通知）
     */
    private Integer itemType;
    /**
     * 流程实例ID
     */
    private String workflowInstanceId;
    /**
     * 流程实例名称
     */
    private String workflowInstanceName;
    /**
     * 详情URL
     */
    private String url;
    /**
     * 详情URL移动端
     */
    private String mobileUrl;
    /**
     * 我的请求详情URL（访问业务系统该待办请求详情的URL）
     */
    private String questUrl;
    /**
     * 我的请求详情URL移动端（访问业务系统移动端该待办请求详情的URL）
     */
    private String mobileQuestUrl;
    /**
     * 发起人账号
     */
    private String sendUserAccount;
    /**
     * 发起人姓名
     */
    private String sendUserName;
    /**
     * 发送人组织名称
     */
    private String sendDeptName;
    /**
     * 发起时间
     */
    private LocalDateTime sendDate;
    /**
     * 接收人账号
     */
    private String receiveUserAccount;
    /**
     * 接收人姓名
     */
    private String receiveUserName;
}
