package com.artfess.cgpt.foreignApi.vo;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.slf4j.MDC;
import org.springframework.context.annotation.DependsOn;

import java.io.Serializable;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2023/10/13 16:10
 */
@Data
@AllArgsConstructor
@ApiModel
@DependsOn
public class ForeignResponseVo<T> implements Serializable {
    @ApiModelProperty(notes = "响应码，非0 即为异常", example = "0")
    private String code;
    @ApiModelProperty(notes = "响应消息", example = "提交成功")
    private String msg;
    @ApiModelProperty(notes = "响应数据")
    private T data;
    @ApiModelProperty(notes = "请求id")
    private String requestId;

    @ApiModelProperty(notes = "成功状态")
    private Boolean success;

    public ForeignResponseVo(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.success = StrUtil.equals("0", code);
        this.requestId = MDC.get("requestId");
    }

    public static <T> ForeignResponseVo<T> ok(String msg, T data) {
        return new ForeignResponseVo<>("0", msg, data);
    }

    public static <T> ForeignResponseVo<T> ok(T data) {
        return new ForeignResponseVo<>("0", "操作成功", data);
    }

    public static <T> ForeignResponseVo<Void> ok() {
        return new ForeignResponseVo<>("0", "操作成功", null);
    }

    public static <T> ForeignResponseVo<T> error(T data) {
        return new ForeignResponseVo<>("400", "", data);
    }

    public static <T> ForeignResponseVo<T> error(String code, String msg, T data) {
        return new ForeignResponseVo<>(code, msg, data);
    }

    public static <T> ForeignResponseVo<T> error(String code, String msg) {
        return new ForeignResponseVo<>(code, msg, null);
    }
}
