package com.artfess.cgpt.foreignApi.service.Impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.*;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.service.WxPublicManager;
import com.artfess.cgpt.foreignApi.vo.*;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.artfess.uc.params.user.UserVo;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:对外接口调用
 * @Author: Rong Tao
 * @Date: 2023/8/10 10:54
 */
@Service
public class ForeignCallServiceImpl implements ForeignCallService {

    @Value("${zsj.getTokenUrl}")
    private String zsjGetTokenUrl;
    @Value("${zfpt.getTokenUrl}")
    private String zfptGetTokenUrl;
    @Value("${zfpt.internalPay}")
    private String internalPayUrl;
    @Value("${zfpt.externalPay}")
    private String externalPayUrl;
    @Value("${zsj.createTaskUrl}")
    private String createTaskUrl;
    @Value("${zsj.completeTaskUrl}")
    private String completeTaskUrl;
    @Value("${zsj.createNoticeUrl}")
    private String createNoticeUrl;
    @Value("${zsj.pushWxMessageUrl}")
    private String pushWxMessageUrl;
    @Value("${zsj.queryUserUrl}")
    private String queryUserUrl;
    @Value("${zsj.pushUserUrl}")
    private String pushUserUrl;

    @Value("${cgpt.porTaskUrl}")
    private String cgptPorTaskUrl;
    @Value("${cgpt.porInstUrl}")
    private String cgptPorInstUrl;

    @Autowired
    BizUtils bizUtils;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Autowired
    BpmTaskManager bpmTaskManager;
    @Autowired
    UserManager userManager;

    @Override
    public void callForeignInterface(String url, Object params,Integer sys) {
        String token = getToken(sys);

        if(BeanUtils.isNotEmpty(token)){
            Map<String,Object> hearders = new HashMap<>();
            hearders.put("Authorization",token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String result = FluentUtil.post(url, Base64.getBase64(jsonNode.toString()), params);
                if(BeanUtils.isNotEmpty(result)){
                    JSONObject jsonObject = JSONUtil.parseObj(result);
                    if(jsonObject.get("state").equals("false")){
                        throw new BaseException("调用第三方接口失败:"+jsonObject.get("message"));
                    }
                }else {
                    throw new BaseException("调用第三方接口失败");
                }
            } catch (Exception e) {
                if(sys==1) {
                    redisUtil.del("zsjToken");
                }
                if(sys==2) {
                    redisUtil.del("zfptToken");
                }
                throw new BaseException("推送失败",e);
            }
        }
    }

    @Override
    public void callForeignInterfaceResponse(String url, Object params,Integer sys) {
        String token = getToken(sys);

        if(BeanUtils.isNotEmpty(token)){
            Map<String,Object> hearders = new HashMap<>();
            hearders.put("Authorization",token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String result = FluentUtil.post(url, Base64.getBase64(jsonNode.toString()), params);
                if(BeanUtils.isNotEmpty(result)){
                    JSONObject jsonObject = JSONUtil.parseObj(result);
                    if(!jsonObject.get("code").equals("0")){
                        throw new BaseException("调用第三方接口失败:"+jsonObject.get("msg"));
                    }
                }else {
                    throw new BaseException("调用第三方接口失败");
                }
            } catch (Exception e) {
                if(sys==1) {
                    redisUtil.del("zsjToken");
                }
                if(sys==2) {
                    redisUtil.del("zfptToken");
                }
                throw new BaseException("推送失败",e);
            }
        }
    }

    @Override
    public JSONObject callInterfaceResponse(String url, JSONObject params, Integer sys) {
        JSONObject jsonObject = new JSONObject();
        String token = getToken(sys);
        if(BeanUtils.isNotEmpty(token)){
            Map<String,Object> hearders = new HashMap<>();
            hearders.put("Authorization",token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String result = FluentUtil.post(url, Base64.getBase64(jsonNode.toString()), params);
                if(BeanUtils.isNotEmpty(result)){
                    jsonObject = JSONUtil.parseObj(result);
                }else {
                    throw new BaseException("调用第三方接口失败");
                }
            } catch (Exception e) {
                throw new BaseException("调用第三方接口失败："+e.getMessage());
            }
        }
        return jsonObject;
    }

    public JSONObject callInterfaceResponse(String url, JSONArray params, Integer sys) {
        JSONObject jsonObject = new JSONObject();
        String token = getToken(sys);
        if(BeanUtils.isNotEmpty(token)){
            Map<String,Object> hearders = new HashMap<>();
            hearders.put("Authorization",token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String result = FluentUtil.post(url, Base64.getBase64(jsonNode.toString()), params);
                if(BeanUtils.isNotEmpty(result)){
                    jsonObject = JSONUtil.parseObj(result);
                }else {
                    throw new BaseException("调用第三方接口失败");
                }
            } catch (Exception e) {
                throw new BaseException("调用第三方接口失败："+e.getMessage());
            }
        }
        return jsonObject;
    }


    @Override
    public ForeignResponseVo callInterface(String url, JSONObject params, Integer sys) {
        ForeignResponseVo result = null;
        String token = getToken(sys);
        if(BeanUtils.isNotEmpty(token)){
            Map<String,Object> hearders = new HashMap<>();
            hearders.put("Authorization",token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String info = FluentUtil.post(url, Base64.getBase64(jsonNode.toString()), params);
                if(BeanUtils.isNotEmpty(info)){
                    result  = JSONUtil.toBean(info, ForeignResponseVo.class);
                }else {
                    throw new BaseException("调用第三方接口失败");
                }
            } catch (Exception e) {
                throw new BaseException("调用第三方接口失败："+e.getMessage());
            }
        }
        return result;
    }



    public String getToken(Integer sys){
        String token = "";

        //默认为主数据
        String redisKey = "zsjToken";
        if(sys==2) {
            redisKey = "zfptToken";
        }

        //1.先获取本地redis中是否存在对应系统的token
        Object redisToken = redisUtil.get(redisKey);
        if(BeanUtils.isEmpty(redisToken)){
            String url = zsjGetTokenUrl;

            //如果没有，调用对应系统获取token接口并存入redis
            Map<String,String> getTokenMap = new HashMap<>();
            String key = null;
            String tokenString = null;
            try {
                //默认获取主数据
                key = EncryptUtil.md5Hex("cgptoRifyipFRldpsV2BmmrEv+XL1eBGkG6gzuKN2ITGFNQHwMzxjUDjXjruC1tssi/8t//f3SUaKqzGLY/r7JPyfpP88ofKDpO3PzxMGbjYrdkHwMzxjUDjXjruC1tssi/8");
                if(sys==2) {
                    //支付平台
                    key = EncryptUtil.md5Hex("cgptoRifyipFRldpsV2BmmrEv+XL1eBGkG6gzuKN2ITGFNQHwMzxjUDjXjruC1tssi/8t//f3SUaKqzGLY/r7JPyfpP88ofKDpO3PzxMGbjYrdkHwMzxjUDjXjruC1tssi/8");
                    url = zfptGetTokenUrl;
                }

                getTokenMap.put("key",key);
                getTokenMap.put("sysCode","cgpt");
                tokenString = FluentUtil.post(url, null, getTokenMap);
            } catch (Exception e) {
                throw new BaseException("获取TOKEN失败",e);
            }

            if(BeanUtils.isNotEmpty(tokenString)) {
                JSONObject jsonObject = JSONUtil.parseObj(tokenString);
                if (BeanUtils.isNotEmpty(jsonObject.get("value"))) {
                    String tokenValue = "Bearer " + jsonObject.get("value").toString();
                    redisUtil.set(redisKey,tokenValue,60*60*8);
                    token = tokenValue;
                }
            }
        }else {
            token = redisToken.toString();
        }

        return token;
    }


    @Override
    public ForeignResponseVo callPay(TransVo trans, Integer type) {
        String payUrl = internalPayUrl;
        if(type==2) {
            payUrl = externalPayUrl;
        }

//        List<HandleDetailed> orderDetails = transactionDetails.getOrderDetails();
//        if(BeanUtils.isNotEmpty(orderDetails) && orderDetails.size()>0){
//            //更改订单明细相关字段为支付平台类型
//            orderDetails.stream().forEach(s->{
//                if(s.getPayType()==1) s.setPayType(5);
//                if(s.getPayType()==15) s.setPayType(10);
//                s.setCompanyCode(orgManager.getById(s.getCompanyId()).getCode());
//            });
//        }
        JSONObject param = JSONUtil.parseObj(trans);
        JSONObject res = callInterfaceResponse(payUrl, param, 2);
        if(BeanUtils.isEmpty(res)) {
            return null;
        }

        ForeignResponseVo result = JSONUtil.toBean(res.toString(), ForeignResponseVo.class);
        return result;
    }

//    @Override
//    @Transactional
//    public ForeignResponseVo callPay(List<TransactionDetails> transList, Integer type) {
//        String payUrl = internalPayUrl;
//        if(type==2) payUrl = externalPayUrl;
//
//        for(TransactionDetails transactionDetails : transList){
//            List<HandleDetailed> orderDetails = transactionDetails.getOrderDetails();
//            if(BeanUtils.isNotEmpty(orderDetails) && orderDetails.size()>0){
//                //更改订单明细相关字段为支付平台类型
//                orderDetails.stream().forEach(s->{
//                    if(s.getPayType()==1) s.setPayType(5);
//                    if(s.getPayType()==15) s.setPayType(10);
//                    s.setCompanyCode(orgManager.getById(s.getCompanyId()).getCode());
//                });
//            }
//
//            //更改相关字段为支付平台类型，并调用内部支付接口
//            if(transactionDetails.getPayType().equals("11")){
//                //退还保证金（支付服务费后剩余保证金退还）
//                transactionDetails.setPayType("6");
//            }
//            if(transactionDetails.getPayType().equals("12")){
//                //退款（未中标手动退还保证金）
//                transactionDetails.setPayType("7");
//            }
//            if(transactionDetails.getPayType().equals("17")){
//                //没收保证金
//                transactionDetails.setPayType("12");
//            }
//            if(transactionDetails.getPayType().equals("15")){
//                //交易服务费
//                transactionDetails.setPayType("10");
//            }
//
//            transactionDetails.setStatementsCode(transactionDetails.getOrderNumber());
//            transactionDetails.setPayUnitCode(orgManager.getById(transactionDetails.getPayUnitCode()).getCode());
//            transactionDetails.setCollectUnitCode(orgManager.getById(transactionDetails.getCollectUnitCode()).getCode());
//        }
//
//        JSONObject param = new JSONObject();
//        param.put("data",transList);
//        JSONObject res = callInterfaceResponse(payUrl, param, 2);
//        if(BeanUtils.isEmpty(res)) return null;
//        ForeignResponseVo result = JSONUtil.toBean(res.toString(), ForeignResponseVo.class);
//        return result;
//    }

//    @Override
//    public JSONObject pushRec(RecVO recVO){
//        JSONObject jsonObject = bizUtils.esbRequest(recServiceId, JSONUtil.toJsonStr(recVO));
//        if(BeanUtils.isEmpty(jsonObject)) return jsonObject;
//        System.out.println("ESB对账单导入接口返回数据:"+jsonObject);
//
//
//
//        return null;
//    }

//    @Override
//    public String pushRec(RecVO recVO) throws Exception{
//        List<RecDetailVO> isdDetail = recVO.getIsdDetail();
//        if(BeanUtils.isEmpty(isdDetail)) throw new BaseException("对账单明细不能为空");
//
//        List<Map<String, Object>> detailMap = MapUtil.entitysToMaps(isdDetail);
//        Map<String, Object> paramMap = MapUtil.entityToMap(recVO);
//        paramMap.put("details", detailMap);
//
//        Map<String, Object> routeMap = new HashMap<>();
//        routeMap.put("SerialNO", UUID.randomUUID().toString());
//        routeMap.put("ServiceID",recServiceId);
//        routeMap.put("SourceSysID", esbSourceSysID);
//        routeMap.put("ServiceTime", System.currentTimeMillis());
//        Map<String, Object> requestMap = new HashMap<>();
//        Map<String, Object> serviceMap = new HashMap<>();
//        Map<String, Object> rootMap = new HashMap<>();
//
//        requestMap.put("Request", paramMap);
//        serviceMap.put("Route", routeMap);
//        serviceMap.put("Data", requestMap);
//        rootMap.put("Service", serviceMap);
//        String result = FluentUtil.post(esbUrl, null, rootMap);
//        System.out.println("------------ESB对账单导入接口返回数据-----------"+result);
//        if (StringUtil.isNotEmpty(result)) {
//            ObjectMapper mapper = new ObjectMapper();
//            JsonNode msgContent = mapper.readTree(result);
//            JsonNode data = msgContent.get("Service").get("Data");
//            if (data != null && data.has("Response")) {
//                if (data.get("Response").has("Text")) {
//                    String str = data.get("Response").get("Text").asText();
//                    str = EncryptUtil.decrypt(str, "123456789qwertgh");
//                    ObjectMapper strmapper = new ObjectMapper();
//                    JsonNode msg = strmapper.readTree(str);
//                    System.out.println("------------解密后返回数据-----------"+msg);
//                    if (msg.get("code").asText().equals("0")) {
//
//                                return msg.get("msg").asText();
//                            }
//                        }
//                    }
//                }
//        return "";
//    }

    @Override
    public String createTokenKey() {
        HttpServletRequest request = HttpUtil.getRequest();
        String tokenStr = request.getHeader("authorization");
        String token = tokenStr.substring(tokenStr.indexOf("Bearer") + 7);

        //生成随机的tokenKey
        String tokenKey = StringUtils.upperCase(RandomStringUtils.randomAlphanumeric(5));
        redisUtil.set(tokenKey, token, 60 * 5);
        return tokenKey;
    }

    @Override
    public CommonResult checkToken(String tokenKey) {
        Object tokenObject = redisUtil.get(tokenKey);
        if (BeanUtils.isEmpty(tokenObject)) {
            return new CommonResult(false, "无效的tokenKey");
        }
        redisUtil.del(tokenKey);
        return new CommonResult(true, "操作成功", tokenObject.toString());
    }

    @Override
    public CommonResult<BizUserVo> getUserByTOKEN() {
        IUser currentUserOrNull = ContextUtil.getCurrentUserOrNull();
        if (null == currentUserOrNull) return new CommonResult<>(false, "无效的token");
        BizUserVo result = new BizUserVo();
        result.setAccount(currentUserOrNull.getAccount());
        result.setFullname(currentUserOrNull.getFullname());
        result.setEmail(currentUserOrNull.getEmail());
        result.setMobile(currentUserOrNull.getMobile());
        return new CommonResult<>(true, "操作成功", result);
    }

    @Override
    public void pushTaskToMh(String instId) throws Exception {

        DefaultBpmProcessInstance proInst = bpmProcessInstanceManager.getById(instId);
        if(BeanUtils.isEmpty(proInst)) {
            return;
        }
        List<DefaultBpmTask> taskList = bpmTaskManager.getByInstId(proInst.getId());
        if(BeanUtils.isEmpty(taskList) || taskList.size()<=0) {
            return;
        }
        DefaultBpmTask task = taskList.get(0);

        MhTaskVO mhTaskVO = new MhTaskVO();
        mhTaskVO.setWorkflowInstanceId(instId);
        mhTaskVO.setTitle(proInst.getSubject());
        mhTaskVO.setItemType(1);
        mhTaskVO.setUrl(cgptPorTaskUrl+task.getId()+"/0");
//        mhTaskVO.setMobileUrl(fjwzczPorTaskMobileUrl+task.getId()+"/0");
        User sendUser = userManager.getById(proInst.getCreateBy());
        if(BeanUtils.isNotEmpty(sendUser)) {
            mhTaskVO.setSendUserAccount(sendUser.getAccount());
        }
        mhTaskVO.setSendUserName(proInst.getCreator());
        User recUser = userManager.getById(task.getAssigneeId());
        if(BeanUtils.isNotEmpty(recUser)) {
            mhTaskVO.setReceiveUserAccount(recUser.getAccount());
        }
        mhTaskVO.setReceiveUserName(task.getAssigneeName());
        mhTaskVO.setSendDate(LocalDateTime.now());

        callForeignInterface(createTaskUrl,mhTaskVO,1);
    }


    @Override
    public void completeTaskToMh(String instId){
        Map<String,Object> params = new HashMap<>();
        params.put("workflowInstanceId",instId);
        params.put("url",cgptPorInstUrl+instId+"/doneList");
//        params.put("mobileUrl",fjwzczPorInstMobileUrl+instId+"/doneList");
        params.put("questUrl",cgptPorInstUrl+instId+"/request");
//        params.put("mobileQuestUrl",fjwzczPorInstMobileUrl+instId+"/request");
        try {
            callForeignInterface(completeTaskUrl,params,1);
        }catch (Exception e){
            e.printStackTrace();
            System.out.println("推送主数据已办失败："+e.getMessage());
        }

    }

    @Override
    public void pushTaskToMhByTaskId(String taskId) throws Exception {
        DefaultBpmTask task = bpmTaskManager.getById(taskId);
        if (BeanUtils.isEmpty(task)) {
            return;
        }

        DefaultBpmProcessInstance proInst = bpmProcessInstanceManager.getById(task.getProcInstId());
        if(BeanUtils.isEmpty(proInst)) {
            return;
        }

        MhTaskVO mhTaskVO = new MhTaskVO();
        mhTaskVO.setWorkflowInstanceId(proInst.getId());
        mhTaskVO.setTitle(proInst.getSubject());
        mhTaskVO.setItemType(1);
        mhTaskVO.setUrl(cgptPorTaskUrl+task.getId()+"/0");
//        mhTaskVO.setMobileUrl(fjwzczPorTaskMobileUrl+task.getId()+"/0");
        mhTaskVO.setQuestUrl(cgptPorInstUrl+task.getProcInstId()+"/request");
//        mhTaskVO.setMobileQuestUrl(fjwzczPorInstMobileUrl+task.getProcInstId()+"/request");
        User sendUser = userManager.getById(proInst.getCreateBy());
        if(BeanUtils.isNotEmpty(sendUser)) {
            mhTaskVO.setSendUserAccount(sendUser.getAccount());
        }
        mhTaskVO.setSendUserName(proInst.getCreator());
        User recUser = userManager.getById(task.getAssigneeId());
        if(BeanUtils.isNotEmpty(recUser)) {
            mhTaskVO.setReceiveUserAccount(recUser.getAccount());
        }
        mhTaskVO.setReceiveUserName(task.getAssigneeName());
        mhTaskVO.setSendDate(LocalDateTime.now());
        mhTaskVO.setWorkflowInstanceName(proInst.getProcDefName());
        Org org = orgManager.getById(proInst.getCreateOrgId());
        mhTaskVO.setSendDeptName(org.getName());

        callForeignInterface(createTaskUrl,mhTaskVO,1);

        //推送模版消息到微信公众号
//        String wxResult = "";
//        try {
//            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//            WxNoticeTemplate wxTemplate = new WxNoticeTemplate();
//            wxTemplate.setKeyword1(LocalDateTime.now().format(formatter));
//            wxTemplate.setKeyword2(proInst.getSubject());
//            wxTemplate.setKeyword3("待审核");
//            String replaceUrl = wxNoticeMsgUrl.replace("CustomUrl",mhTaskVO.getMobileUrl());
//            wxTemplate.setUrl(replaceUrl);
//            wxTemplate.setTemplateId(wxTaskTemplateId);
//            wxTemplate.setUserAccount(mhTaskVO.getReceiveUserAccount());
//            wxResult = pushWxMessage(wxTemplate).toString();
//        }catch (Exception e){
//            e.printStackTrace();
//            wxResult = e.getMessage();
//        } finally {
//            System.out.println("推送待办消息到微信公众号："+wxResult);
//        }

    }

//    @Override
//    public void pushSucBidNotice(List<BizHandleNoticeDetailed> detailedList) {
//        List<MhSucBidNoticeVO> sucBidNoticeVOS = new ArrayList<>();
//        for(BizHandleNoticeDetailed detail : detailedList){
//            if(BeanUtils.isEmpty(detail.getWinnerCompanyName())) continue;
//            MhSucBidNoticeVO sucBidNoticeVO = new MhSucBidNoticeVO();
//            sucBidNoticeVO.setProjectCode(detail.getProjectNumber());
//            sucBidNoticeVO.setNoticeTitle(detail.getHandleNoticeTitle());
//            sucBidNoticeVO.setAffCompany(detail.getHandleDetailedCompanyName());
//            sucBidNoticeVO.setCategory(2);
//            sucBidNoticeVO.setTrader(detail.getWinnerCompanyName());
//            sucBidNoticeVO.setDealMaterial(detail.getMatName());
//            sucBidNoticeVO.setDealPrice(detail.getTransactionPrice());
//            sucBidNoticeVO.setDealTime(detail.getAuctionEndDate());
//            sucBidNoticeVO.setStartAuctionTime(detail.getAuctionStartDate());
//            sucBidNoticeVO.setEndAuctionTime(detail.getAuctionEndDate());
//            sucBidNoticeVO.setDetailedUrl(detail.getId());
//            sucBidNoticeVO.setStatus(1);
//            sucBidNoticeVOS.add(sucBidNoticeVO);
//        }
//
//        HashMap<String,Object> paramMap = new HashMap<>();
//        paramMap.put("data",sucBidNoticeVOS);
//        if(sucBidNoticeVOS.size()>0) callForeignInterfaceResponse(createSucBidNoticeUrl,paramMap,1);
//
//    }

    @Override
    public void pushNoticeToMh(PushNoticeVO mhNoticeVO) {
        callForeignInterface(createNoticeUrl,mhNoticeVO,1);
    }

    @Override
    public JSONObject pushWxMessage(WxNoticeTemplate wxNoticeTemplate) {
        JSONObject param = JSONUtil.parseObj(wxNoticeTemplate);
        JSONObject jsonObject = callInterfaceResponse(pushWxMessageUrl, param, 1);
        return jsonObject;
    }

    @Override
    public JSONObject queryUser(User queryVO) {
        JSONObject param = JSONUtil.parseObj(queryVO);
        JSONObject jsonObject = callInterfaceResponse(queryUserUrl, param, 1);
        return jsonObject;
    }

    @Override
    public JSONObject pushUser(UserVo vo) {
        JSONObject param = JSONUtil.parseObj(vo);
        JSONObject jsonObject = callInterfaceResponse(pushUserUrl, param, 1);
        return jsonObject;
    }

}
