package com.artfess.cgpt.expert.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.expert.model.BizExpertType;
import com.artfess.cgpt.expert.manager.BizExpertTypeManager;

import java.util.Arrays;
import java.util.List;

/**
 * 专家分类表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizExpertType/v1/")
@Api(tags="专家分类表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizExpertTypeController extends BaseController<BizExpertTypeManager, BizExpertType> {

    @PostMapping("/save")
    @ApiOperation(value = "M-添加或修改专家分类")
    public CommonResult save(@RequestBody BizExpertType entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询专家分类详情")
    public CommonResult<BizExpertType> selectOne(@RequestParam("id") String id){
//        BizExpertDatabase result=baseService.getExpertById(id);
        BizExpertType result = baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除专家")
    public CommonResult remove(@RequestParam("ids") String ids){
        baseService.removeByIds(Arrays.asList(ids.split(",")));
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizExpertType>> queryAllByPage(@RequestBody QueryFilter<BizExpertType> queryFilter){
        PageList<BizExpertType> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
