package com.artfess.cgpt.evaluation.model;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 评标体系明细表，只有综合评标法有明细，最低价评标法无明细
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizEvaluationSystemDescription对象", description="评标体系明细表，只有综合评标法有明细，最低价评标法无明细")
@TableName("biz_evaluation_system_description")
@Data
public class BizEvaluationSystemDescription extends BizNoModel<BizEvaluationSystemDescription> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项评标模版历史ID（关联立项评标模版历史ID表ID）")
    @TableField("EVALUATION_SYSTEM_ID_")
    private String evaluationSystemId;

    @ApiModelProperty(value = "评分项父级ID（评分因素）")
    @TableField("EVALUATION_ITEM_PID_")
    private String evaluationItemPid;

    @ApiModelProperty(value = "评分项父级名称（评分因素）")
    @TableField("EVALUATION_ITEM_PNAME_")
    private String evaluationItemPname;

    @ApiModelProperty(value = "评分内容")
    @TableField("EVALUATION_ITEM_CODE_")
    private String evaluationItemCode;

    @ApiModelProperty(value = "评分标准")
    @TableField("EVALUATION_STANDARD_")
    private String evaluationStandard;

    @ApiModelProperty(value = "分值")
    @TableField("EVALUATION_SCORE_")
    private BigDecimal evaluationScore;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "评分因素")
    @TableField(exist = false)
    private String scoringFactors;

    @ApiModelProperty(value = "评分内容")
    @TableField(exist = false)
    private String scoringContent;

    @ApiModelProperty(value = "评标得分")
    @TableField(exist = false)
    private BigDecimal score;
    @ApiModelProperty(value = "评标得分ID")
    @TableField(exist = false)
    private String bidEvaId;

    @ApiModelProperty(value = "立项ID")
    @TableField(exist = false)
    private String noticeId;
    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField(exist = false)
    private Integer noticeType;
    @ApiModelProperty(value = "立项明细ID")
    @TableField(exist = false)
    private String noticeDetailId;
    @ApiModelProperty(value = "报价公司ID")
    @TableField(exist = false)
    private String orgId;

}
