package com.artfess.cgpt.evaluation.dao;

import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 评标体系明细表，只有综合评标法有明细，最低价评标法无明细 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizEvaluationSystemDescriptionDao extends BaseMapper<BizEvaluationSystemDescription> {

    /**
     * 根据评标体系Id查询
     * @param sysId 评标体系Id
     * @return
     */
    List<BizEvaluationSystemDescription> selectBySysId(@Param("sysId") String sysId);

    /**
     * 根据评标体系Id查询（包含报价企业评标得分）
     * @param sysId 评标体系Id
     * @return
     */
    List<BizEvaluationSystemDescription> selectBySysIdAndScore(@Param("sysId") String sysId,
                                                               @Param("noticeId") String noticeId,
                                                               @Param("orgId") String orgId,
                                                               @Param("noticeDetailId") String noticeDetailId,
                                                               @Param("operaterId") String operaterId);

}
