package com.artfess.cgpt.contract.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合同物料明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@ApiModel(value="BizContractMatItem对象", description="合同物料明细表")
@Data
public class BizContractMatItem extends BaseModel<BizContractMatItem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "序号")
    @TableField("SORT_")
    private Integer sort;

    @ApiModelProperty(value = "关联合同表合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "关联合同表合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "执行价格截止日期")
    @TableField("PRICE_EXECUTION_END_")
    private LocalDate priceExecutionEnd;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_NUMBER_")
    private String noticeNumber;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类CODE，关联物料分类CODE")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "采购方式（使用字典，1：平台招标，2：企业招标，3：企业线下定价）")
    @TableField("PROCUREMENT_METHOD_")
    private String procurementMethod;

    @ApiModelProperty(value = "招标方式（使用字典，1：招标采购:2：邀请招标采购:3：竞争性谈判:4：竞价采购:5：询价采购:6：单一来源采购:7：多源采购）")
    @TableField("APPLICATION_METHOD_")
    private String applicationMethod;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private String hasQualification;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "服务费金额")
    @TableField("FEE_MONEY")
    private BigDecimal feeMoney;

    @ApiModelProperty(value = "总金额")
    @TableField("TOTAL_PRICE")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "税额")
    @TableField("TAXATION")
    private BigDecimal taxation;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "地址")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "购买时间（车辆处理）/ 注册登记日期(闲置设备)")
    @TableField("BUY_DATE_")
    private String buyDate;

    @ApiModelProperty(value = "检验有效期至（车辆处理）")
    @TableField("INSURANCE_PERIOD_END_")
    private String insurancePeriodEnd;

    @ApiModelProperty(value = "排量（车辆处理）")
    @TableField("DISPLACEMENT_")
    private String displacement;

    @ApiModelProperty(value = "保险期至（车辆处理）")
    @TableField("INSPECTION_VALIDITY_")
    private String inspectionValidity;

    @ApiModelProperty(value = "原值")
    @TableField("ORIGINAL_VALUE_")
    private String originalValue;

    @ApiModelProperty(value = "数量（默认值：1）")
    @TableField("NUM_")
    private Double num;

    @ApiModelProperty(value = "含税竞价底价（单位：元）")
    @TableField("BASE_PRICE_")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "税率（百分比）")
    @TableField("TAX_RATE_")
    private Double taxRate;

    @ApiModelProperty(value = "拍卖方式（使用字典，1：物料报价，2：标包报价）")
    @TableField("AUCTION_METHOD_")
    private Integer auctionMethod;

    @ApiModelProperty(value = "加价幅度（单位：元），标包报价时无加价幅度")
    @TableField("PRICE_INCREASE_")
    private Integer priceIncrease;

    @ApiModelProperty(value = "加价倍数（输入加价倍数，默认值：1）")
    @TableField("PRICE_ADD_RULES_")
    private Integer priceAddRules;

    @ApiModelProperty(value = "开始竞拍时间")
    @TableField("AUCTION_START_DATE_")
    private LocalDateTime auctionStartDate;

    @ApiModelProperty(value = "结束竞拍时间")
    @TableField("AUCTION_END_DATE_")
    private LocalDateTime auctionEndDate;

    @ApiModelProperty(value = "竞拍成交价格")
    @TableField("TRANSACTION_PRICE_")
    private BigDecimal transactionPrice;

    @ApiModelProperty(value = "竞拍最高价格")
    @TableField("BIDDING_MAX_PRICE_")
    private BigDecimal biddingMaxPrice;

    @ApiModelProperty(value = "保证金（单位：元）")
    @TableField("BOND_")
    private BigDecimal bond;

    @ApiModelProperty(value = "竞得人报价排名")
    @TableField("WINNER_USER_RANKING_")
    private Integer winnerUserRanking;

    @ApiModelProperty(value = "交易服务费（单位：百分比）")
    @TableField("TRANSACTION_SERVICE_FEE_")
    private BigDecimal transactionServiceFee;

    @ApiModelProperty(value = "有无资质要求（1：无，2：有）")
    @TableField("HAS_QUALIFICATIONS_")
    private Integer hasQualifications;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;


}
