package com.artfess.cgpt.contract.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合同表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@ApiModel(value="BizContract对象", description="合同表")
@TableName("biz_contract")
@Data
public class BizContract extends BizModel<BizContract> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目），默认1")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "成交通知ID")
    @TableField("WIN_NOTICE_ID_")
    private String winNoticeId;

    @ApiModelProperty(value = "合同编号")
    @TableField("CONTR_CODE_")
    private String contrCode;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTR_NAME_")
    private String contrName;

    @ApiModelProperty(value = "合同类型（1.标准合同，2.固定单价合同，3.固定数量合同）")
    @TableField("CONTR_METHOD_")
    private Integer contrMethod;

    @ApiModelProperty(value = "第三方接口合同id")
    @TableField("THREE_CONTRACT_ID")
    private String threeContractId;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "采购公司编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "采购公司联系人ID")
    @TableField("MAT_COMPANY_USER_ID_")
    private String matCompanyUserId;

    @ApiModelProperty(value = "采购公司联系人")
    @TableField("MAT_COMPANY_USER_NAME_")
    private String matCompanyUserName;

    @ApiModelProperty(value = "采购公司联系方式")
    @TableField("MAT_COMPANY_USER_PHONE_")
    private String matCompanyUserPhone;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编号")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "供应商税号")
    @TableField("VENDOR_TAX_NUMBER_")
    private String vendorTaxNumber;

    @ApiModelProperty(value = "供应商联系人ID")
    @TableField("VENDOR_USER_ID_")
    private String vendorUserId;

    @ApiModelProperty(value = "供应商联系人")
    @TableField("VENDOR_USER_NAME_")
    private String vendorUserName;

    @ApiModelProperty(value = "供应商联系方式")
    @TableField("VENDOR_USER_PHONE_")
    private String vendorUserPhone;

    @ApiModelProperty(value = "签订日期")
    @TableField("SIGN_DATA_")
    private LocalDate signData;

    @ApiModelProperty(value = "付款方式（1：现金，2：承兑，3：其他），默认1")
    @TableField("PAY_METHOD_")
    private Integer payMethod;

    @ApiModelProperty(value = "采购商审批人")
    @TableField("MAT_COMPANY_CHECKER_ID_")
    private String matCompanyCheckerId;

    @ApiModelProperty(value = "采购商审批人名称")
    @TableField("MAT_COMPANY_CHECKER_NAME_")
    private String matCompanyCheckerName;

    @ApiModelProperty(value = "合同金额")
    @TableField("CONTRACT_AMOUNT_")
    private BigDecimal contractAmount;

    @ApiModelProperty(value = "合同开始日期")
    @TableField("CONTRACT_START_DATE_")
    private LocalDate contractStartDate;

    @ApiModelProperty(value = "合同结束日期")
    @TableField("CONTRACT_END_DATE_")
    private LocalDate contractEndDate;

    @ApiModelProperty(value = "合同内容")
    @TableField("TREATY_CONTENTS_")
    private String treatyContents;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "合同状态（1：草稿，2：签订中，3：已签订，4：待审核（审批），5：已审核，" +
            "6：审核未通过，7.审核中（流程）），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "生成类型（1.手工添加，2.代采生成），默认1")
    @TableField("GENER_TYPE_")
    private Integer generType;

    @ApiModelProperty(value = "代采合同id")
    @TableField("AGENCY_CONTRCT_ID_")
    private String agencyContrctId;

    @ApiModelProperty(value = "是否含税（1：含税，2：不含税），默认1")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "是否代采（0.否，1.是），默认0")
    @TableField("IS_AGENCY_PROCURE_")
    private Integer isAgencyProcure;

    @ApiModelProperty(value = "合同明细集合")
    @TableField(exist = false)
    private List<ContractItem> itemList;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "采购商签署人委托人ID")
    @TableField("MAT_COMPANY_CLIENT_ID_")
    private String matCompanyClientId;

    @ApiModelProperty(value = "采购商签署人委托人名称")
    @TableField("MAT_COMPANY_CLIENT_NAME_")
    private String matCompanyClientName;

    @ApiModelProperty(value = "订单状态（0.未生成订单，1.已生成订单），默认0")
    @TableField("ORDER_STATUS_")
    private Integer orderStatus;

    @ApiModelProperty(value = "订单ID（关联订单表ID）")
    @TableField("ORDER_ID_")
    private String orderId;

}
