package com.artfess.cgpt.contract.dao;

import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.contract.model.BizContract;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

/**
 * 合同表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
public interface BizContractDao extends BaseMapper<BizContract> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizContract> queryAllByPage(IPage<BizContract> convert2IPage, @Param("ew") Wrapper<BizContract> convert2Wrapper);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizContract> pageVendorGroup(IPage<BizContract> convert2IPage, @Param("ew") Wrapper<BizContract> convert2Wrapper);

    /**
     * 统计立项未签订合同的数量
     * @param noticeId 立项id
     * @param vendorId 供应商id
     * @return
     */
    Integer getNoSignContrCount(@Param("noticeId") String noticeId,@Param("vendorId") String vendorId);

}
