package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:评标详情表（综合评标法）
 * @Author: Rong Tao
 * @Date: 2024/7/4 19:54
 */
@ApiModel(value="BidEvaluationRecord对象", description="评标详情表（综合评标法）")
@TableName("biz_bid_evaluation_record")
@Data
public class BidEvaluationRecord extends BizNoModel<BidEvaluationRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "操作时间")
    @TableField("OPERATE_TIME_")
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "操作人ID")
    @TableField("OPERATE_USER_ID_")
    private String operateUserId;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATE_USER_NAME_")
    private String operateUserName;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "采购立项明细ID，关联采购立项明细表ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    private String procureOrgName;

    @ApiModelProperty(value = "报价记录ID（关联报价表ID）")
    @TableField("QUOTATION_ID_")
    private String quotationId;

    @ApiModelProperty(value = "报价公司ID")
    @TableField("QUOTATION_ORG_ID_")
    private String quotationOrgId;

    @ApiModelProperty(value = "报价公司名称")
    @TableField("QUOTATION_ORG_NAME_")
    private String quotationOrgName;

    @ApiModelProperty(value = "报价公司编号")
    @TableField("QUOTATION_ORG_CODE_")
    private String quotationOrgCode;

    @ApiModelProperty(value = "报价单价")
    @TableField("QUOTATION_PRICE_")
    private BigDecimal quotationPrice;

    @ApiModelProperty(value = "报价总额")
    @TableField("QUOTATION_AMOUNT_")
    private BigDecimal quotationAmount;

    @ApiModelProperty(value = "评标方法（1：综合评标法，2：最低价评标法）")
    @TableField("EVALUATING_METHODS_")
    private Integer evaluatingMethods;

    @ApiModelProperty(value = "评标方式（1.以物料评标，2.以供应商评标）")
    @TableField("EVALUATION_MODE_")
    private Integer evaluationMode;

    @ApiModelProperty(value = "得分")
    @TableField("SCORE_")
    private BigDecimal score;

    @ApiModelProperty(value = "评标说明")
    @TableField("EVA_EXPLAIN_")
    private String evaExplain;

    @ApiModelProperty(value = "状态（1.草稿，2.已提交），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "评分详情明细集合")
    @TableField(exist = false)
    private List<BidEvaluationDetail> evaluationDetailList;

}
