package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.CalibrationDetailDao;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationDetailManager;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/4/25 16:16
 */
@Service
public class CalibrationDetailManagerImpl extends BaseManagerImpl<CalibrationDetailDao, CalibrationDetail> implements CalibrationDetailManager {

    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private MatApprovalDetailsManager maDetailManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalDetailsManager paDetailManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;

    @Override
    public PageList<CalibrationDetail> queryAllByPage(QueryFilter<CalibrationDetail> queryFilter) {
        IPage<CalibrationDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void calibraZh(BizBiddingQuotation quotation) {
        LambdaQueryWrapper<CalibrationDetail> caQW = new LambdaQueryWrapper<>();
        caQW.eq(CalibrationDetail::getNoticeId,quotation.getNoticeId());
        super.remove(caQW);

        //1.根据公告和报价公司查询报价数据
        LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
        quoQW.eq(BizBiddingQuotation::getNoticeId,quotation.getNoticeId())
                .eq(BizBiddingQuotation::getQuotationCompanyId,quotation.getQuotationCompanyId());
        List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);
        if(BeanUtils.isEmpty(quoList) || quoList.size()<=0) {
            throw new BaseException("报价数据异常");
        }

        List<CalibrationDetail> data = new ArrayList<>();
        for(BizBiddingQuotation quo : quoList){
            CalibrationDetail temp = new CalibrationDetail();

            temp.setNoticeId(quo.getNoticeId());
            temp.setVendorId(quo.getQuotationCompanyId());
            temp.setVendorCode(quo.getQuotationCompanyCode());
            temp.setVendorName(quo.getQuotationCompanyName());
            temp.setNoticeDetailedId(quo.getNoticeDetailedId());
            temp.setIsTax(quo.getIsTax());
            temp.setStatus(1);
            temp.setWinBidPrice(quo.getQuotationPrice());
            if(quotation.getNoticeType().equals("1")){
                MatApproval notice = matApprovalManager.getById(quotation.getNoticeId());
                temp.setNoticeCode(notice.getProjectNumber());
                temp.setNoticeName(notice.getNoticeTitle());
                temp.setProcureOrgId(notice.getProcureOrgId());
                temp.setProcureOrgCode(notice.getProcureOrgCode());
                temp.setProcureOrgName(notice.getProcureOrgName());
                MatApprovalDetails detail = maDetailManager.getById(quo.getNoticeDetailedId());
                temp.setMatId(detail.getMatId());
                temp.setMatPlatcode(detail.getMatPlatcode());
                temp.setMatCategoryCode(detail.getMatCategoryCode());
                temp.setMatCode(detail.getMatCode());
                temp.setMatName(detail.getMatName());
                temp.setMatMaterial(detail.getMatMaterial());
                temp.setMatSpec(detail.getMatSpec());
                temp.setMatNum(detail.getMatNum());
                temp.setMatUnit(detail.getMatUnit());
                temp.setMatBrand(detail.getMatBrand());
                temp.setMatBaseExt(detail.getMatBaseExt());
                temp.setMatOtherExt(detail.getMatOtherExt());
                temp.setTaxRate(detail.getTaxRate());
            }else {
                ProjectApproval notice = projectApprovalManager.getById(quotation.getNoticeId());
                temp.setNoticeCode(notice.getNoticeCode());
                temp.setNoticeName(notice.getNoticeTitle());
                temp.setProcureOrgId(notice.getProcureOrgId());
                temp.setProcureOrgCode(notice.getProcureOrgCode());
                temp.setProcureOrgName(notice.getProcureOrgName());
                ProjectApprovalDetails detail = paDetailManager.getById(quo.getNoticeDetailedId());
                temp.setMatId(detail.getMatId());
                temp.setMatPlatcode(detail.getMatPlatcode());
                temp.setMatCategoryCode(detail.getMatCategoryCode());
                temp.setMatCode(detail.getMatCode());
                temp.setMatName(detail.getMatName());
                temp.setMatMaterial(detail.getMatMaterial());
                temp.setMatSpec(detail.getMatSpec());
                temp.setMatNum(detail.getMatNum());
                temp.setMatUnit(detail.getMatUnit());
                temp.setMatBrand(detail.getMatBrand());
                temp.setMatBaseExt(detail.getMatBaseExt());
                temp.setMatOtherExt(detail.getMatOtherExt());
                temp.setTaxRate(detail.getTaxRate());
            }
            data.add(temp);
        }
        super.saveBatch(data);
    }

}
