/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.PrintService;
import net.qiyuesuo.sdk.bean.contract.Document;
import net.qiyuesuo.sdk.bean.print.EntiFakePrintRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.CollectionUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class PrintServiceImpl
implements PrintService {
    private SDKClient client;

    public PrintServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String getEntiFakePrintUrl(Long contractId) throws PrivateAppException {
        return this.getEntiFakePrintUrl(contractId, null);
    }

    @Override
    public String getEntiFakePrintUrl(Long contractId, List<Long> documentIds) throws PrivateAppException {
        return this.getEntiFakePrintUrl(new EntiFakePrintRequest(contractId, documentIds, null, null));
    }

    @Override
    public String getEntiFakePrintUrl(EntiFakePrintRequest request) throws PrivateAppException {
        List<Long> documentIds;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(request.getContractId()));
        if (StringUtils.isNotBlank(request.getPrinterContact())) {
            paramers.addParam("printerContact", String.valueOf(request.getPrinterContact()));
        }
        if (StringUtils.isNotBlank(request.getPrinterName())) {
            paramers.addParam("printerName", String.valueOf(request.getPrinterName()));
        }
        if (request.getUseCurrentUser() != null) {
            paramers.addParam("useCurrentUser", request.getUseCurrentUser().toString());
        }
        if (request.getDocumentId() != null) {
            paramers.addParam("documentId", request.getDocumentId().toString());
        }
        if (request.getVisitNum() != null) {
            paramers.addParam("visitNum", request.getVisitNum().toString());
        }
        if (request.getInvalidToPage() != null) {
            paramers.addParam("invalidToPage", request.getInvalidToPage());
        }
        if (CollectionUtils.isNotEmpty(documentIds = request.getDocumentIds())) {
            StringBuilder docIds = new StringBuilder();
            for (Long documentId : documentIds) {
                if (documentId == null) continue;
                docIds.append(documentId + ",");
            }
            if (docIds.length() > 0) {
                paramers.addParam("documentIds", docIds.substring(0, docIds.length() - 1));
            }
        }
        Map<String, Object> result = this.client.doService("/contract/efprinturl", paramers);
        return (String)result.get("printUrl");
    }

    @Override
    public void setPrintCount(Long contractId, int count) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        paramers.addParam("count", String.valueOf(count));
        this.client.doService("/contract/setprintcount", paramers);
    }

    @Override
    public int getPrintCount(Long contractId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/getprintcount", paramers);
        int count = (Integer)result.get("printCount");
        return count;
    }

    @Override
    public void setDocumentPrintCount(List<Document> documents) throws PrivateAppException {
        this.client.doServiceWithJson("/document/setprintcount", JSONUtils.toJson(documents));
    }

    @Override
    public int getDocumentPrintCount(Long documentId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("documentId", String.valueOf(documentId));
        Map<String, Object> result = this.client.doService("/document/getprintcount", paramers);
        int count = (Integer)result.get("printCount");
        return count;
    }
}

