/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.AddDocumentByFile;
import net.qiyuesuo.sdk.bean.contract.AddDocumentByTemplate;
import net.qiyuesuo.sdk.bean.contract.AddDocumentByUrl;
import net.qiyuesuo.sdk.bean.contract.ContractCancelRequest;
import net.qiyuesuo.sdk.bean.contract.ContractDetail;
import net.qiyuesuo.sdk.bean.contract.ContractDownloadRequest;
import net.qiyuesuo.sdk.bean.contract.ContractFinish;
import net.qiyuesuo.sdk.bean.contract.ContractListRequest;
import net.qiyuesuo.sdk.bean.contract.ContractListResponse;
import net.qiyuesuo.sdk.bean.contract.ContractOperationLog;
import net.qiyuesuo.sdk.bean.contract.ContractPerminssionBean;
import net.qiyuesuo.sdk.bean.contract.ContractQueryRequest;
import net.qiyuesuo.sdk.bean.contract.ContractQueryResult;
import net.qiyuesuo.sdk.bean.contract.CreateContractByTemplateIdsRequest;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Document;
import net.qiyuesuo.sdk.bean.contract.DocumentParams;
import net.qiyuesuo.sdk.bean.contract.FinishContractRequest;
import net.qiyuesuo.sdk.bean.contract.MultiSignatoryEdit;
import net.qiyuesuo.sdk.bean.contract.OffLineSignRequest;
import net.qiyuesuo.sdk.bean.contract.SendContractRequest;
import net.qiyuesuo.sdk.bean.contract.SignatoryEdit;
import net.qiyuesuo.sdk.bean.contract.StamperType;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.bean.contract.WaterMarkContent;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByFileRequest;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByFilesRequest;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.document.DocumentFillParam;
import net.qiyuesuo.sdk.bean.document.DownloadDocRequest;
import net.qiyuesuo.sdk.bean.document.FillFormRequest;
import net.qiyuesuo.sdk.bean.document.FormDTO;
import net.qiyuesuo.sdk.bean.sign.FillParamRequest;
import net.qiyuesuo.sdk.bean.sign.PreSignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.bean.sign.SignatoryRect;
import net.qiyuesuo.sdk.bean.sign.SignatoryStatus;
import net.qiyuesuo.sdk.bean.transmit.ContractTransmit;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.CollectionUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class ContractServiceImpl
implements ContractService {
    private SDKClient client;

    public ContractServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public Long createDocument(InputStream inputStream, String title) throws PrivateAppException {
        return this.createDocument(inputStream, title, null);
    }

    @Override
    public Long createDocument(InputStream inputStream, String title, List<WaterMarkContent> waterMarks) throws PrivateAppException {
        return this.createDocument(new DocumentCreateByFileRequest(inputStream, title, waterMarks));
    }

    @Override
    public Long createDocument(DocumentCreateByFileRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getInputStream() != null) {
            StreamFile fileItem = new StreamFile(request.getInputStream());
            paramers.addFile("file", fileItem);
        }
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if (request.getForm() != null) {
            paramers.addParam("form", JSONUtils.toJson(request.getForm()));
        }
        if (request.getWidth() != null && request.getHeight() != null) {
            paramers.addParam("width", request.getWidth().toString());
            paramers.addParam("height", request.getHeight().toString());
        }
        Map<String, Object> result = this.client.doService("/document/createbyfile", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public CreateDocumentResult createByFile(CreateDocumentRequest request) throws PrivateAppException {
        int serverVersion;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addFile("file", request.getFile());
        paramers.addParam("fileType", request.getFileType());
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if (request.getWidth() != null && request.getHeight() != null) {
            paramers.addParam("width", request.getWidth().toString());
            paramers.addParam("height", request.getHeight().toString());
        }
        if (request.getForm() != null) {
            paramers.addParam("form", JSONUtils.toJson(request.getForm()));
        }
        Map<String, Object> result = (serverVersion = this.getServerVersion()) >= StringUtils.getVersion("3.9.0") ? this.client.doService("/v2/document/createbyfile", paramers) : this.client.doService("/document/createbyfile", paramers);
        Long documentId = null;
        if (serverVersion >= StringUtils.getVersion("3.9.0")) {
            Map document = (Map)result.get("result");
            if (document == null) {
                return null;
            }
            documentId = Long.valueOf((String)document.get("documentId"));
        } else {
            documentId = Long.valueOf((String)result.get("documentId"));
        }
        CreateDocumentResult createResult = new CreateDocumentResult();
        createResult.setDocumentId(documentId);
        return createResult;
    }

    private int getServerVersion() throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        Map<String, Object> result = this.client.doService("/version/info", paramers);
        String serverVersionStr = (String)result.get("result");
        if (StringUtils.isBlank(serverVersionStr)) {
            throw new PrivateAppException(1000001, "\u670d\u52a1\u5668\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        return StringUtils.getVersion(serverVersionStr);
    }

    @Override
    public void addWatermark(WaterMarkContent waterMarkContent) throws PrivateAppException {
        this.client.doServiceWithJson("/document/addwatermark", JSONUtils.toJson(waterMarkContent));
    }

    @Override
    public Long createDocument(List<InputStream> inputStreams, String title) throws PrivateAppException {
        return this.createDocument(inputStreams, title, null);
    }

    @Override
    public Long createDocument(List<InputStream> inputStreams, String title, List<WaterMarkContent> waterMarks) throws PrivateAppException {
        return this.createDocument(new DocumentCreateByFilesRequest(inputStreams, title, waterMarks));
    }

    @Override
    public Long createDocument(DocumentCreateByFilesRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        for (InputStream inputStream : request.getInputStreams()) {
            StreamFile fileItem = new StreamFile(inputStream);
            fileItems.add(fileItem);
        }
        paramers.addListFiles("files", fileItems);
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if (request.getWidth() != null && request.getHeight() != null) {
            paramers.addParam("width", request.getWidth().toString());
            paramers.addParam("height", request.getHeight().toString());
        }
        Map<String, Object> result = this.client.doService("/document/createbyfiles", paramers);
        return Long.valueOf((String)result.get("documentId"));
    }

    @Override
    public Long createDocument(Long templateId, Map<String, String> params, String title) throws PrivateAppException {
        return this.createDocument(templateId, params, title, null);
    }

    @Override
    public Long createDocument(Long templateId, Map<String, String> params, String title, List<WaterMarkContent> waterMarks) throws PrivateAppException {
        return this.createDocument(templateId, params, title, waterMarks, null);
    }

    @Override
    public Long createDocumentByLocalFile(String filePath, String title) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("filePath", filePath);
        paramers.addParam("title", title);
        Map<String, Object> result = this.client.doService("/document/createbylocalfile", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long createDocumentByUrl(String url, String title) throws PrivateAppException {
        return this.createDocumentByUrl(url, title, null);
    }

    @Override
    public Long createDocumentByUrl(String url, String title, List<WaterMarkContent> waterMarks) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("url", url);
        paramers.addParam("title", title);
        if (waterMarks != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(waterMarks));
        }
        Map<String, Object> result = this.client.doService("/document/createbyurl", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long createDocumentByUrl(DocumentCreateByUrl request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/v2/document/createbyurl", JSONUtils.toJson(request));
        Map data = (Map)result.get("result");
        Long documentId = Long.valueOf((String)data.get("documentId"));
        return documentId;
    }

    @Override
    public Long createSponsorDocumentByFile(InputStream inputStream, String title) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (inputStream != null) {
            StreamFile fileItem = new StreamFile(inputStream);
            paramers.addFile("file", fileItem);
        }
        paramers.addParam("title", title);
        Map<String, Object> result = this.client.doService("/document/createsponsorfile", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long addDocumentByFile(AddDocumentByFile request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(request.getFile());
        paramers.addFile("file", fileItem);
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if (request.getWidth() != null && request.getHeight() != null) {
            paramers.addParam("width", request.getWidth().toString());
            paramers.addParam("height", request.getHeight().toString());
        }
        Map<String, Object> result = this.client.doService("/document/addbyfile", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long addDocumentByTemplate(AddDocumentByTemplate request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("title", request.getTitle());
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if (request.getTemplateId() != null) {
            paramers.addParam("templateId", request.getTemplateId().toString());
        }
        if (request.getParams() != null && !request.getParams().isEmpty()) {
            paramers.addParam("params", JSONUtils.toJson(request.getParams()));
        }
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        Map<String, Object> result = this.client.doService("/document/addbytemplate", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long addSponsorDocumentByFile(AddDocumentByFile request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(request.getFile());
        paramers.addFile("file", fileItem);
        paramers.addParam("title", request.getTitle());
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        Map<String, Object> result = this.client.doService("/document/addsponsorfile", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public void addAttachment(InputStream attachment, Long documentId, String title, String description) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (attachment != null) {
            StreamFile fileItem = new StreamFile(attachment);
            paramers.addFile("attachment", fileItem);
        }
        if (documentId != null) {
            paramers.addParam("documentId", String.valueOf(documentId));
        }
        paramers.addParam("title", title);
        paramers.addParam("description", description);
        this.client.doService("/document/addattachment", paramers);
    }

    @Override
    public Long createContract(CreateContractRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/create", JSONUtils.toJson(request));
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public Long createContractByCategory(CreateContractRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/createbycategory", JSONUtils.toJson(request));
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public Long editContract(CreateContractRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/createRetainParams", JSONUtils.toJson(request));
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public void edit(CreateContractRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/edit", JSONUtils.toJson(request));
    }

    @Override
    public void send(SendContractRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/send", JSONUtils.toJson(request));
    }

    @Override
    public void complete(Long contractId) throws PrivateAppException {
        FinishContractRequest request = new FinishContractRequest();
        request.setContractId(contractId);
        Map<String, Object> result = this.client.doServiceWithJson("/contract/finish", JSONUtils.toJson(request));
    }

    @Override
    public ContractDetail detail(Long contractId) throws PrivateAppException {
        return this.detail(contractId, null);
    }

    @Override
    public ContractDetail detail(Long contractId, Boolean countSeal) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        if (countSeal != null) {
            paramers.addParam("countSeal", String.valueOf(countSeal));
        }
        Map<String, Object> result = this.client.doService("/contract/detail", paramers);
        Map contractMap = (Map)result.get("contract");
        ContractDetail detail = new ContractDetail();
        try {
            detail = MapUtils.toObject(contractMap, ContractDetail.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25", e);
        }
        return detail;
    }

    @Override
    public Long createDocument(InputStream inputStream, String title, List<WaterMarkContent> waterMarks, FormDTO form) throws PrivateAppException {
        return this.createDocument(new DocumentCreateByFileRequest(inputStream, title, waterMarks, form));
    }

    @Override
    public Map<Long, Boolean> fillTextFieldsToPdf(FillFormRequest request) throws PrivateAppException {
        Map<String, Object> postResult = this.client.doServiceWithJson("/document/fillTextFields", JSONUtils.toJson(request.getForms()));
        Integer code = (Integer)postResult.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u586b\u5199\u8868\u5355\u57df\u5931\u8d25\uff0c" + postResult.get("message"));
        }
        Map result = (Map)postResult.get("resultMap");
        return result;
    }

    @Override
    public Long createDocument(Long templateId, Map<String, String> params, String title, List<WaterMarkContent> waterMarks, FormDTO form) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (templateId != null) {
            paramers.addParam("templateId", templateId.toString());
        }
        paramers.addParam("title", title);
        if (params != null && !params.isEmpty()) {
            String json = JSONUtils.toJson(params);
            paramers.addParam("params", json);
        }
        if (waterMarks != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(waterMarks));
        }
        if (form != null) {
            paramers.addParam("form", JSONUtils.toJson(form));
        }
        Map<String, Object> result = this.client.doService("/document/createbytemplate", paramers);
        return Long.valueOf((String)result.get("documentId"));
    }

    @Override
    public void download(Long contractId, OutputStream outputStream) throws PrivateAppException {
        this.download(contractId, null, null, outputStream);
    }

    @Override
    public void download(Long contractId, String contact, String name, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        if (StringUtils.isNotBlank(contact)) {
            paramers.addParam("contact", contact);
        }
        if (StringUtils.isNotBlank(name)) {
            paramers.addParam("name", name);
        }
        this.client.download("/contract/download", paramers, outputStream);
    }

    @Override
    public void download(ContractDownloadRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        paramers.addParam("bizId", request.getBizId());
        paramers.addParam("contact", request.getContact());
        paramers.addParam("name", request.getName());
        paramers.addParam("downloadItems", request.getDownloadItemsString());
        if (request.getNeedCompressForOneFile() != null) {
            paramers.addParam("needCompressForOneFile", String.valueOf(request.getNeedCompressForOneFile()));
        }
        this.client.download("/contract/download", paramers, request.getOutputStream());
    }

    @Override
    public void downloadDoc(Long documentId, OutputStream outputStream) throws PrivateAppException {
        this.downloadDoc(new DownloadDocRequest(documentId, outputStream, null, null));
    }

    @Override
    public void downloadDoc(DownloadDocRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getDocumentId().toString() != null) {
            paramers.addParam("documentId", String.valueOf(request.getDocumentId()));
            Long.toString(request.getDocumentId());
        }
        paramers.addParam("contact", request.getContact());
        paramers.addParam("name", request.getName());
        this.client.download("/document/download", paramers, request.getOutputStream());
    }

    @Override
    public void downloadImgDoc(Long documentId, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("documentId", String.valueOf(documentId));
        this.client.download("/document/download/imgdoc", paramers, outputStream);
    }

    @Override
    public Long createDocument(String html, String title) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("html", html);
        paramers.addParam("title", title);
        Map<String, Object> result = this.client.doService("/document/createbyhtml", paramers);
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public void cencelContract(Long contractId, Long sealId, String reason, Boolean removeContract) throws PrivateAppException {
        this.cancelContract(contractId, null, sealId, reason, removeContract);
    }

    @Override
    public void cancelContract(Long contractId, Long sealId, String reason, Boolean removeContract) throws PrivateAppException {
        this.cancelContract(contractId, null, sealId, reason, removeContract);
    }

    @Override
    public void cancelContract(String bizId, Long sealId, String reason, Boolean removeContract) throws PrivateAppException {
        this.cancelContract(null, bizId, sealId, reason, removeContract);
    }

    public void cancelContract(Long contractId, String bizId, Long sealId, String reason, Boolean removeContract) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        if (StringUtils.isNotBlank(bizId)) {
            paramers.addParam("bizId", bizId);
        }
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if (StringUtils.isNotBlank(reason)) {
            paramers.addParam("reason", reason);
        }
        if (removeContract != null) {
            paramers.addParam("removeContract", removeContract.toString());
        }
        this.client.doService("/contract/cancel", paramers);
    }

    @Override
    public void cancelContract(ContractCancelRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if (StringUtils.isNotBlank(request.getBizId())) {
            paramers.addParam("bizId", request.getBizId());
        }
        if (request.getSealId() != null) {
            paramers.addParam("sealId", String.valueOf(request.getSealId()));
        }
        if (StringUtils.isNotBlank(request.getSealName())) {
            paramers.addParam("sealName", request.getSealName());
        }
        if (StringUtils.isNotBlank(request.getSealCategoryName())) {
            paramers.addParam("sealCategoryName", request.getSealCategoryName());
        }
        if (StringUtils.isNotBlank(request.getReason())) {
            paramers.addParam("reason", request.getReason());
        }
        if (request.getRemoveContract() != null) {
            paramers.addParam("removeContract", String.valueOf(request.getRemoveContract()));
        }
        this.client.doService("/contract/cancel", paramers);
    }

    @Override
    public void recallContract(Long contractId, String reason) throws PrivateAppException {
        if (contractId == null) {
            throw new PrivateAppException(1000001, "contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        if (StringUtils.isNotBlank(reason)) {
            paramers.addParam("reason", reason);
        }
        this.client.doService("/contract/recall", paramers);
    }

    @Override
    public String viewUrl(Long contractId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/viewurl", paramers);
        String viewUrl = (String)result.get("viewUrl");
        return viewUrl;
    }

    @Override
    public String viewUrl(ViewUrlRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(request.getContractId()));
        if (request.getExpireTime() != null) {
            paramers.addParam("expireTime", String.valueOf(request.getExpireTime()));
        }
        if (request.getPageType() != null) {
            paramers.addParam("pageType", request.getPageType().name());
        }
        if (request.getDocumentId() != null) {
            paramers.addParam("documentId", request.getDocumentId().toString());
        }
        if (request.getPageMode() != null) {
            paramers.addParam("pageMode", request.getPageMode().name());
        }
        if (request.getCanReturn() != null) {
            paramers.addParam("canReturn", request.getCanReturn().toString());
        }
        if (request.getCanViewDetail() != null) {
            paramers.addParam("canViewDetail", request.getCanViewDetail().toString());
        }
        if (request.getCancelable() != null) {
            paramers.addParam("cancelable", request.getCancelable().toString());
        }
        if (request.getAllowDownload() != null) {
            paramers.addParam("allowDownload", request.getAllowDownload().toString());
        }
        if (request.getAllowPrint() != null) {
            paramers.addParam("allowPrint", request.getAllowPrint().toString());
        }
        if (request.getVisitNum() != null) {
            paramers.addParam("visitNum", request.getVisitNum().toString());
        }
        if (request.getInvalidToPage() != null) {
            paramers.addParam("invalidToPage", request.getInvalidToPage());
        }
        if (request.getAllowTab() != null) {
            paramers.addParam("allowTab", request.getAllowTab().toString());
        }
        Map<String, Object> result = this.client.doService("/contract/viewurl", paramers);
        String viewUrl = (String)result.get("viewUrl");
        return viewUrl;
    }

    @Override
    public String preSignUrl(Long contractId) throws PrivateAppException {
        return this.preSignUrl(contractId, null);
    }

    @Override
    public String preSignUrl(Long contractId, String operatorContact) throws PrivateAppException {
        return this.preSignUrl(new PreSignUrlRequest(contractId, operatorContact));
    }

    @Override
    public String preSignUrl(PreSignUrlRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getContractId() == null) {
            throw new PrivateAppException(1000001, "contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        paramers.addParam("contractId", String.valueOf(request.getContractId()));
        if (request.getCanSetStamper() != null) {
            paramers.addParam("canSetStamper", request.getCanSetStamper().toString());
        }
        if (request.getCanSetParam() != null) {
            paramers.addParam("canSetParam", request.getCanSetParam().toString());
        }
        if (request.getCanSend() != null) {
            paramers.addParam("canSend", request.getCanSend().toString());
        }
        if (request.getCanSaveOrClose() != null) {
            paramers.addParam("canSaveOrClose", request.getCanSaveOrClose().toString());
        }
        if (request.getLanguage() != null) {
            paramers.addParam("language", request.getLanguage().toString());
        }
        if (StringUtils.isNotBlank(request.getOperatorContact())) {
            paramers.addParam("operatorContact", request.getOperatorContact());
        }
        if (request.getDocumentId() != null) {
            paramers.addParam("documentId", request.getDocumentId().toString());
        }
        if (request.getVisitNum() != null) {
            paramers.addParam("visitNum", request.getVisitNum().toString());
        }
        if (request.getInvalidToPage() != null) {
            paramers.addParam("invalidToPage", request.getInvalidToPage());
        }
        Map<String, Object> result = this.client.doService("/contract/presignurl", paramers);
        return (String)result.get("presignUrl");
    }

    @Override
    public void downloadFaceEvidenceFile(Long contractId, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        this.client.download("/contract/face/download/zip", paramers, outputStream);
    }

    @Override
    public List<Signatory> queryLocations(Long contractId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        Map<String, Object> result = this.client.doService("/contract/query/location", paramers);
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        if (result.get("result") != null) {
            List sigs = (List)result.get("result");
            for (Map map : sigs) {
                Signatory sig = new Signatory();
                sig.setTenantName((String)map.get("tenantName"));
                sig.setTenantType(TenantType.valueOf((String)map.get("tenantType")));
                sig.setReceiverType(TenantType.valueOf((String)map.get("receiverType")));
                sig.setReceiverName((String)map.get("receiverName"));
                sig.setSerialNo((Integer)map.get("serialNo"));
                sig.setStatus(SignatoryStatus.valueOf((String)map.get("status")));
                if (map.get("locations") != null) {
                    List tempLocations = (List)map.get("locations");
                    ArrayList<SignatoryRect> locations = new ArrayList<SignatoryRect>();
                    for (Map tempLoaction : tempLocations) {
                        SignatoryRect location = new SignatoryRect();
                        location.setSignatoryId(Long.valueOf((String)tempLoaction.get("signatoryId")));
                        location.setDocumentId((String)tempLoaction.get("documentId") != null ? Long.valueOf((String)tempLoaction.get("documentId")) : null);
                        location.setRectType(StamperType.valueOf((String)tempLoaction.get("rectType")));
                        location.setPage((Integer)tempLoaction.get("page"));
                        location.setWidth((Double)tempLoaction.get("width"));
                        location.setHeight((Double)tempLoaction.get("height"));
                        location.setOffsetX((Double)tempLoaction.get("offsetX"));
                        location.setOffsetY((Double)tempLoaction.get("offsetY"));
                        location.setKeyword((String)tempLoaction.get("keyword"));
                        location.setDocuments((String)tempLoaction.get("documents"));
                        locations.add(location);
                    }
                    sig.setLocations(locations);
                }
                signatories.add(sig);
            }
        }
        return signatories;
    }

    @Override
    public String signUrl(SignUrlRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl", JSONUtils.toJson(request));
        String signUrl = (String)result.get("signUrl");
        return signUrl;
    }

    @Override
    public void forceFinish(ContractFinish contractFinish) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/finish/force", JSONUtils.toJson(contractFinish));
    }

    @Override
    public ContractFinish forceFinishAddAttachement(Long contractId, String attachment) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpPostParamers();
        if (contractId != null) {
            params.addParam("contractId", String.valueOf(contractId));
        }
        params.addParam("attachment", attachment);
        Map<String, Object> result = this.client.doService("/contract/finish/addattachment", params);
        ContractFinish finish = new ContractFinish();
        if (result.get("result") != null) {
            Map record = (Map)result.get("result");
            finish.setAttachment((String)record.get("attachement"));
            finish.setCompanyName((String)record.get("companyName"));
            finish.setContractId(Long.valueOf((String)record.get("contractId")));
            finish.setFinishReason((String)record.get("finishReason"));
            finish.setUserName((String)record.get("userName"));
        }
        return finish;
    }

    @Override
    public void press(Long actionId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("actionId", String.valueOf(actionId));
        this.client.doService("/contract/press/operator", paramers);
    }

    @Override
    public void pressOperator(Long signatoryId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("signatoryId", String.valueOf(signatoryId));
        this.client.doService("/contract/press/operator", paramers);
    }

    @Override
    public ContractListResponse list(ContractListRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            paramers.addParam("companyName", String.valueOf(request.getCompanyName()));
        }
        if (request.getSelectOffset() != null) {
            paramers.addParam("selectOffset", String.valueOf(request.getSelectOffset()));
        }
        if (request.getSelectLimit() != null) {
            paramers.addParam("selectLimit", String.valueOf(request.getSelectLimit()));
        }
        if (request.getOrderMode() != null) {
            paramers.addParam("orderMode", String.valueOf(request.getOrderMode()));
        }
        Map<String, Object> result = this.client.doService("/contract/list", paramers);
        Map resultMap = (Map)result.get("result");
        ContractListResponse response = new ContractListResponse();
        if (resultMap != null) {
            response.setTotalCount(((Integer)resultMap.get("totalCount")).intValue());
            List contractList = (List)resultMap.get("contractList");
            if (CollectionUtils.isNotEmpty(contractList)) {
                ArrayList<ContractDetail> contracts = new ArrayList<ContractDetail>();
                for (Map contractMap : contractList) {
                    ContractDetail contract = new ContractDetail(contractMap);
                    contracts.add(contract);
                }
                response.setContractList(contracts);
            }
        }
        return response;
    }

    @Override
    public void notify(Long contractId) throws PrivateAppException {
        if (contractId == null) {
            throw new PrivateAppException(1000001, "\u8bf7\u8f93\u5165\u5408\u540cid");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        this.client.doService("/contract/notify", paramers);
    }

    @Override
    public void batchDownload(List<Long> contractIds, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (CollectionUtils.isNotEmpty(contractIds)) {
            String contractIdsStr = "";
            for (int i = 0; i < contractIds.size(); ++i) {
                Long contractId = contractIds.get(i);
                if (contractId == null) continue;
                if (i != 0) {
                    contractIdsStr = contractIdsStr + ",";
                }
                contractIdsStr = contractIdsStr + contractId;
            }
            paramers.addParam("contractIds", contractIdsStr);
        }
        this.client.download("/contract/batchdowload", paramers, outputStream);
    }

    @Override
    public void delete(Long contractId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        this.client.doService("/contract/delete", paramers);
    }

    @Override
    public void fillParam(FillParamRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/fillparam", JSONUtils.toJson(request));
    }

    @Override
    public Long createContractByTemplateIds(CreateContractByTemplateIdsRequest request) throws PrivateAppException {
        if (request == null) {
            throw new PrivateAppException(1000001, "\u53c2\u6570:CreateContractByTemplateIdsRequest \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(request.getTemplateIds())) {
            throw new PrivateAppException(1000001, "\u53c2\u6570:templateIds \u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean titleEffective = false;
        if (CollectionUtils.isNotEmpty(request.getTitles()) && request.getTitles().size() == request.getTemplateIds().size()) {
            titleEffective = true;
        }
        int titleIndex = 0;
        ArrayList<Long> documentIds = new ArrayList<Long>();
        for (Long templateId : request.getTemplateIds()) {
            Long documentId = this.createDocument(templateId, request.getParams(), titleEffective ? request.getTitles().get(titleIndex) : request.getSubject(), null);
            documentIds.add(documentId);
            ++titleIndex;
        }
        CreateContractRequest contractRequest = new CreateContractRequest();
        contractRequest.setSubject(request.getSubject());
        contractRequest.setDocuments(documentIds);
        contractRequest.setSend(request.getSend());
        return this.createContract(contractRequest);
    }

    @Override
    public Long editCrontractByTemplateIds(CreateContractByTemplateIdsRequest request) throws PrivateAppException {
        if (request == null) {
            throw new PrivateAppException(1000001, "\u53c2\u6570:CreateContractByTemplateIdsRequest \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(request.getTemplateIds())) {
            throw new PrivateAppException(1000001, "\u53c2\u6570:templateIds \u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean titleEffective = false;
        if (CollectionUtils.isNotEmpty(request.getTitles()) && request.getTitles().size() == request.getTemplateIds().size()) {
            titleEffective = true;
        }
        int titleIndex = 0;
        ArrayList<Long> documentIds = new ArrayList<Long>();
        for (Long templateId : request.getTemplateIds()) {
            Long documentId = this.createDocument(templateId, request.getParams(), titleEffective ? request.getTitles().get(titleIndex) : request.getSubject(), null);
            documentIds.add(documentId);
            ++titleIndex;
        }
        CreateContractRequest contractRequest = new CreateContractRequest();
        contractRequest.setSubject(request.getSubject());
        contractRequest.setDocuments(documentIds);
        contractRequest.setSend(request.getSend());
        contractRequest.setId(request.getContractId());
        return this.editContract(contractRequest);
    }

    @Override
    public List<ContractOperationLog> queryOperationLog(ContractOperationLog condition) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (condition.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(condition.getContractId()));
        }
        paramers.addParam("operation", condition.getOperation());
        paramers.addParam("operatorContact", condition.getOperatorContact());
        Map<String, Object> result = this.client.doService("/contract/operationlog", paramers);
        List contractOperationLogMaps = (List)result.get("result");
        ArrayList<ContractOperationLog> contractOperationLogs = new ArrayList();
        try {
            contractOperationLogs = MapUtils.toObjectList(contractOperationLogMaps, ContractOperationLog.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return contractOperationLogs;
    }

    @Override
    public void addTransmitter(ContractTransmit transmitter) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/transmit", JSONUtils.toJson(transmitter));
    }

    @Override
    public DocumentParams documentParams(Long contractId, String bizId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (contractId == null && StringUtils.isEmpty(bizId)) {
            throw new PrivateAppException("contractId\u6216BizId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        if (bizId != null) {
            paramers.addParam("bizId", bizId);
        }
        Map<String, Object> result = this.client.doService("/contract/documentparams", paramers);
        Boolean sponsorComplete = (Boolean)result.get("sponsorComplete");
        DocumentParams documentParams = new DocumentParams();
        documentParams.setSponsorComplete(sponsorComplete);
        try {
            List documentMap = (List)result.get("documents");
            List<Document> documents = MapUtils.toObjectList(documentMap, Document.class);
            documentParams.setDocuments(documents);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return documentParams;
    }

    @Override
    public ContractPerminssionBean queryPermission(ContractPerminssionBean request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        paramers.addParam("bizId", request.getBizId());
        paramers.addParam("contact", request.getContact());
        Map<String, Object> result = this.client.doService("/contract/permission", paramers);
        ContractPerminssionBean contractPermission = null;
        Map contractPermissionMap = (Map)result.get("result");
        try {
            contractPermission = MapUtils.toObject(contractPermissionMap, ContractPerminssionBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return contractPermission;
    }

    @Override
    public void contractEndTime(Long contractId, String endTime) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        paramers.addParam("endTime", endTime);
        this.client.doService("/contract/endtime", paramers);
    }

    @Override
    public void fillParams(DocumentFillParam request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/fillparams", JSONUtils.toJson(request));
    }

    @Override
    public void editSignatory(SignatoryEdit request) throws PrivateAppException {
        if (request.getContractId() == null) {
            throw new PrivateAppException(1000001, "contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getRawSignatory().getTenantType() == null) {
            throw new PrivateAppException(1000001, "tenantType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.client.doServiceWithJson("/contract/editsignatory", JSONUtils.toJson(request));
    }

    @Override
    public void multiEditSignatory(MultiSignatoryEdit request) throws PrivateAppException {
        if (request.getContractId() == null) {
            throw new PrivateAppException(1000001, "contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SignatoryEdit> list = request.getSignatoryEdits();
        if (CollectionUtils.isEmpty(list)) {
            throw new PrivateAppException(1000001, "\u7b7e\u7f72\u65b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SignatoryEdit edit : list) {
            if (edit.getRawSignatory().getTenantType() != null) continue;
            throw new PrivateAppException(1000001, "tenantType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.client.doServiceWithJson("/contract/multieditsignatory", JSONUtils.toJson(request));
    }

    @Override
    public String sweepCodeUrl(Long contractId, String bizId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (contractId == null && StringUtils.isEmpty(bizId)) {
            throw new PrivateAppException(1000001, "contractId\u6216BizId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        if (bizId != null) {
            paramers.addParam("bizId", bizId);
        }
        Map<String, Object> result = this.client.doService("/contarct/sweepcode/url", paramers);
        String url = (String)result.get("result");
        return url;
    }

    @Override
    public ContractQueryResult queryContract(ContractQueryRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getContact() != null) {
            paramers.addParam("contact", request.getContact());
        }
        paramers.addParam("contractStatus", request.getContractStatus());
        paramers.addParam("selectOffset", request.getSelectOffset().toString());
        paramers.addParam("selectLimit", request.getSelectLimit().toString());
        if (request.getCreateTimeStart() != null) {
            paramers.addParam("createTimeStart", TimeUtils.format(request.getCreateTimeStart(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (request.getCreateTimeEnd() != null) {
            paramers.addParam("createTimeEnd", TimeUtils.format(request.getCreateTimeEnd(), "yyyy-MM-dd HH:mm:ss"));
        }
        Map<String, Object> result = this.client.doService("/contract/query", paramers);
        ContractQueryResult response = null;
        try {
            response = MapUtils.toObject(result, ContractQueryResult.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return response;
    }

    @Override
    public void signCancelContract(ContractCancelRequest contractCancelRequest) throws PrivateAppException {
        Long contractId = contractCancelRequest.getContractId();
        if (contractId == null && StringUtils.isEmpty(contractCancelRequest.getBizId())) {
            throw new PrivateAppException(1000001, "contractId\u6216BizId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(contractCancelRequest.getTenantName())) {
            throw new PrivateAppException(1000001, "tenantName\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        this.client.doServiceWithJson("/contract/cancel/sign", JSONUtils.toJson(contractCancelRequest));
    }

    @Override
    public Long reSendContract(CreateContractRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/resend", JSONUtils.toJson(request));
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public void downloadBrief(ContractDownloadRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(request.getContractId()));
        paramers.addParam("bizId", request.getBizId());
        this.client.download("/contract/download/brief", paramers, request.getOutputStream());
    }

    @Override
    public void bindOffLineFile(OffLineSignRequest request) throws PrivateAppException {
        if (request.getContractId() == null && StringUtils.isBlank(request.getBizId())) {
            throw new PrivateAppException(1000001, "contractId\u3001bizId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(request.getDocumentIds())) {
            throw new PrivateAppException(1000001, "documentIds\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.client.doServiceWithJson("/contract/bind/offlinefile", JSONUtils.toJson(request));
    }

    @Override
    public void updateOffLineFile(Long rawDocumentId, Long newDocumentId) throws PrivateAppException {
        if (rawDocumentId == null || newDocumentId == null) {
            throw new PrivateAppException(1000001, "rawDocumentId\u6216newDocumentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("rawDocumentId", rawDocumentId.toString());
        paramers.addParam("newDocumentId", newDocumentId.toString());
        this.client.doService("/contract/update/offlinefile", paramers);
    }

    @Override
    public Long addDocumentByUrl(AddDocumentByUrl request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("file", request.getUrl());
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if (request.getWidth() != null && request.getHeight() != null) {
            paramers.addParam("width", request.getWidth().toString());
            paramers.addParam("height", request.getHeight().toString());
        }
        if ((code = (Integer)(result = this.client.doService("/document/addbyfile", paramers)).get("code")) != 0) {
            throw new Exception("\u6dfb\u52a0\u9644\u4ef6\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }
}

