/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.utils;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.date.DateTime;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.enums.FileTypeEnum;
import com.artfess.cgpt.utils.EasyPoiStyle;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jsonwebtoken.lang.Collections;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BizUtils {
    public static String getCurrentOrgCode(UCFeignService ucFeignService) {
        ObjectNode orgInfo;
        String orgId = ContextUtil.getCurrentOrgId();
        String orgCode = "";
        if (BeanUtils.isNotEmpty((Object)orgId) && BeanUtils.isNotEmpty((Object)(orgInfo = ucFeignService.getOrgByIdOrCode(orgId)))) {
            orgCode = orgInfo.get("code").asText();
        }
        return orgCode;
    }

    public static String getNextSerialNumber(SystemConfigFeignService scfService, String alias) {
        String platCode = scfService.getNextIdByAlias(alias);
        JSONObject jsonObject = new JSONObject((Object)platCode);
        Object value = jsonObject.get((Object)"value");
        return value.toString();
    }

    public static String currentIsBuyer(UCFeignService ucFeignService, String userId) {
        String result = "";
        CommonResult userById = ucFeignService.getUserById(userId);
        if (BeanUtils.isNotEmpty((Object)userById) && BeanUtils.isNotEmpty((Object)((JsonNode)userById.getValue()).get("mobile"))) {
            result = ((JsonNode)userById.getValue()).get("mobile").asText();
        }
        return result;
    }

    public static QueryFilter addFilterByOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column) {
        User user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            CommonResult userNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if (BeanUtils.isNotEmpty((Object)orgInfo)) {
                orgCode = orgInfo.get("code").asText();
            }
            if ((userNode = ucFeignService.getUserById(userId)).getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                queryFilter.addFilter(column, (Object)orgCode, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }

    public static QueryFilter addFilterByUserOrgAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column) {
        User user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            CommonResult userNode = ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                queryFilter.addFilter(column, (Object)orgId, QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
            }
        }
        return queryFilter;
    }

    public static QueryFilter addFilterByUserOrgAndRoleBusiness(QueryFilter queryFilter, UCFeignService ucFeignService, String column) {
        User user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            CommonResult userNode = ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (null != userType && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin") || set.contains("jcgly"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                queryFilter.addFilter(column, (Object)orgId, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }

    public static QueryFilter addFilterByHisOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column, EnterpriseManager enterpriseManager) {
        IUser user = com.artfess.uc.api.impl.util.ContextUtil.getCurrentUserOrNull();
        if (null != user) {
            JsonNode userJsonNode;
            CommonResult userNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = com.artfess.uc.api.impl.util.ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if (BeanUtils.isNotEmpty((Object)orgInfo)) {
                orgCode = orgInfo.get("code").asText();
            }
            if ((userNode = ucFeignService.getUserById(userId)).getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                Enterprise enterprise = enterpriseManager.getByOrgIdOrCode(orgId, orgCode);
                queryFilter.addFilter(column, (Object)orgCode, QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
                if (BeanUtils.isNotEmpty((Object)((Object)enterprise))) {
                    queryFilter.addFilter(column, (Object)enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
                }
            }
        }
        return queryFilter;
    }

    public static QueryFilter addFilterByUserAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column) {
        User user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            CommonResult userNode = ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                queryFilter.addFilter(column, (Object)userId, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }

    public static boolean isAdmin(UCFeignService ucFeignService) {
        User user = ContextUtil.getCurrentUser();
        boolean disableAll = false;
        if (null != user) {
            JsonNode userJsonNode;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            CommonResult userNode = ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("yygly") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
        }
        return disableAll;
    }

    public static <T> List<T> list(List<T> list) {
        return null == list ? new ArrayList() : list;
    }

    public static QueryFilter handleFilter(QueryFilter queryFilter, String mAlias, String lAlias) {
        queryFilter.addFilter(mAlias + ".IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter(lAlias + ".IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter(lAlias + ".VALID_FLAG_", (Object)1, QueryOP.EQUAL);
        return queryFilter;
    }

    public static String captureName(String str) {
        char[] cs = str.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static String handleDateFormat(Date date) {
        return null == date ? "" : new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String dateFormatChineseStyle(Date date) {
        return null == date ? "" : new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5").format(date);
    }

    public static String handleStringFormat(String str) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str;
    }

    public static void handelCell(HSSFWorkbook workbook, String sheetName, HSSFCell cell, String value, boolean ... title) {
        cell.setCellValue(StringUtils.isEmpty((Object)value) ? " " : value);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short)14);
            font.setBold(true);
        }
        font.setColor(IndexedColors.BLACK.index);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        cell.setCellStyle(cellStyle);
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 1536);
        int colWidth = sheet.getColumnWidth(cell.getColumnIndex()) * 2;
        sheet.autoSizeColumn(cell.getColumnIndex());
        if (colWidth < 65280) {
            sheet.setColumnWidth(cell.getColumnIndex(), colWidth < 3000 ? 3000 : colWidth);
        } else {
            sheet.setColumnWidth(cell.getColumnIndex(), 6000);
        }
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30.0f);
    }

    public static void handelCell(HSSFWorkbook workbook, HSSFCellStyle cellStyle, String sheetName, HSSFCell cell, String value, boolean ... title) {
        cell.setCellValue(StringUtils.isEmpty((Object)value) ? " " : value);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short)14);
            font.setBold(true);
        }
        font.setColor(IndexedColors.BLACK.index);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        cell.setCellStyle(cellStyle);
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 1536);
        int colWidth = sheet.getColumnWidth(cell.getColumnIndex()) * 2;
        sheet.autoSizeColumn(cell.getColumnIndex());
        if (colWidth < 65280) {
            sheet.setColumnWidth(cell.getColumnIndex(), colWidth < 3000 ? 3000 : colWidth);
        } else {
            sheet.setColumnWidth(cell.getColumnIndex(), 6000);
        }
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30.0f);
    }

    public static void handelCell(HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFFont font, String sheetName, HSSFCell cell, String value, boolean ... title) {
        cell.setCellValue(StringUtils.isEmpty((Object)value) ? " " : value);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short)14);
            font.setBold(true);
        }
        font.setColor(IndexedColors.BLACK.index);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        cell.setCellStyle(cellStyle);
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 1536);
        int colWidth = sheet.getColumnWidth(cell.getColumnIndex()) * 2;
        sheet.autoSizeColumn(cell.getColumnIndex());
        if (colWidth < 65280) {
            sheet.setColumnWidth(cell.getColumnIndex(), colWidth < 3000 ? 3000 : colWidth);
        } else {
            sheet.setColumnWidth(cell.getColumnIndex(), 6000);
        }
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30.0f);
    }

    public static String changeMoney(double v) {
        String UNIT = "\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206";
        String DIGIT = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        double MAX_VALUE = 9.99999999999999E12;
        if (v < 0.0 || v > 9.99999999999999E12) {
            return "\u53c2\u6570\u975e\u6cd5!";
        }
        long l = Math.round(v * 100.0);
        if (l == 0L) {
            return "\u96f6\u5143\u6574";
        }
        String strValue = l + "";
        int i = 0;
        int j = "\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206".length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        while (i < strValue.length()) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if ("\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206".charAt(j) == '\u4ebf' || "\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206".charAt(j) == '\u4e07' || "\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206".charAt(j) == '\u5143') {
                    rs = rs + "\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206".charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "\u96f6";
                    isZero = false;
                }
                rs = rs + "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".charAt(ch - 48) + "\u4e07\u5343\u4f70\u62fe\u4ebf\u5343\u4f70\u62fe\u4e07\u5343\u4f70\u62fe\u5143\u89d2\u5206".charAt(j);
            }
            ++i;
            ++j;
        }
        if (!rs.endsWith("\u5206")) {
            rs = rs + "\u6574";
        }
        rs = rs.replaceAll("\u4ebf\u4e07", "\u4ebf");
        return rs;
    }

    public static String getDicValueByCode(List<DictModel> dic, String code) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (!ele.getValue().equals(code)) continue;
            return ele.getName();
        }
        return "";
    }

    public static String getDicValueByCode(List<DictModel> dic, Integer code) {
        return BizUtils.getDicValueByCode(dic, String.valueOf(code));
    }

    public static String getDicCodeByValue(List<DictModel> dic, String value) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (!ele.getName().equals(value)) continue;
            return ele.getValue();
        }
        return "";
    }

    public static Integer getDicCodeByValue_Int(List<DictModel> dic, String value) {
        if (Collections.isEmpty(dic)) {
            return null;
        }
        for (DictModel ele : dic) {
            if (!ele.getName().equals(value)) continue;
            return Integer.valueOf(ele.getValue());
        }
        return null;
    }

    public static String convertNumber(String value) {
        switch (value) {
            case "1": {
                return "one";
            }
            case "2": {
                return "two";
            }
            case "3": {
                return "three";
            }
            case "4": {
                return "four";
            }
            case "5": {
                return "five";
            }
            case "6": {
                return "six";
            }
            case "7": {
                return "seven";
            }
            case "8": {
                return "eight";
            }
            case "9": {
                return "nine";
            }
            case "10": {
                return "ten";
            }
            case "11": {
                return "eleven";
            }
            case "12": {
                return "twelve";
            }
            case "13": {
                return "thirteen";
            }
            case "14": {
                return "fourteen";
            }
            case "15": {
                return "fifteen";
            }
        }
        return value;
    }

    public static String convertNumber(Integer value) {
        return BizUtils.convertNumber(String.valueOf(value));
    }

    public static String converttoChinaNumber(String value) {
        switch (value) {
            case "1": {
                return "\u4e00";
            }
            case "2": {
                return "\u4e8c";
            }
            case "3": {
                return "\u4e09";
            }
            case "4": {
                return "\u56db";
            }
            case "5": {
                return "\u4e94";
            }
            case "6": {
                return "\u516d";
            }
            case "7": {
                return "\u4e03";
            }
            case "8": {
                return "\u516b";
            }
            case "9": {
                return "\u4e5d";
            }
            case "10": {
                return "\u5341";
            }
            case "11": {
                return "\u5341\u4e00";
            }
            case "12": {
                return "\u5341\u4e8c";
            }
            case "13": {
                return "\u5341\u4e09";
            }
            case "14": {
                return "\u5341\u56db";
            }
            case "15": {
                return "\u5341\u4e94";
            }
        }
        return "";
    }

    public static String converttoChinaNumber(Integer value) {
        return BizUtils.converttoChinaNumber(String.valueOf(value));
    }

    public static void setDefaultValue(Object object) {
        String defaultStr = "";
        Date defaultDate = new Date();
        BigDecimal defaultDecimal = new BigDecimal(0);
        try {
            Class<?> clazz = object.getClass();
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String fieldName = field.getName();
                Class<?> fieldClass = field.getType();
                field.setAccessible(true);
                if (!BizUtils.isFieldValueNull(fieldName, object)) continue;
                if (fieldClass == Integer.class) {
                    field.set(object, defaultDecimal.intValue());
                    continue;
                }
                if (fieldClass == Long.class) {
                    field.set(object, defaultDecimal.longValue());
                    continue;
                }
                if (fieldClass == Float.class) {
                    field.set(object, defaultDecimal.doubleValue());
                    continue;
                }
                if (fieldClass == BigDecimal.class) {
                    field.set(object, defaultDecimal);
                    continue;
                }
                if (fieldClass == Date.class) {
                    field.set(object, defaultDate);
                    continue;
                }
                if (fieldClass != String.class) continue;
                field.set(object, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    private static boolean isFieldValueNull(String fieldName, Object object) throws ClassNotFoundException {
        boolean isNUll = false;
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = object.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(object, new Object[0]);
            if (value == null || "null".equals(String.valueOf(value))) {
                isNUll = true;
            }
            return isNUll;
        }
        catch (Exception e) {
            return isNUll;
        }
    }

    public static String getYearByQueryFields(List<QueryField> queryFields) throws Exception {
        String year = null;
        for (QueryField ele : queryFields) {
            if ("COMMENCEMENT_TIME_".equalsIgnoreCase(ele.getProperty())) {
                List value;
                if (null != ele.getValue() && ele.getValue() instanceof Date) {
                    year = new SimpleDateFormat("yyyy").format(DateUtils.parseDate((String)ele.getValue().toString(), (String)"yyyy-MM-dd"));
                }
                if (null == ele.getValue() || !(ele.getValue() instanceof List) || null == (value = (List)ele.getValue()) || value.size() <= 0) break;
                year = new SimpleDateFormat("yyyy").format(DateUtils.parseDate((String)value.get(0).toString(), (String)"yyyy-MM-dd"));
                break;
            }
            if (null != year || !"CREATE_TIME_".equalsIgnoreCase(ele.getProperty())) continue;
            if (null == ele.getValue() || !(ele.getValue() instanceof Date)) break;
            year = String.valueOf(((LocalDateTime)ele.getValue()).getYear());
            break;
        }
        return year;
    }

    public static Boolean isProjectIdFields(List<QueryField> queryFields) {
        for (QueryField ele : queryFields) {
            if (!"pm.ID_".equalsIgnoreCase(ele.getProperty()) && ele.getProperty().toUpperCase().indexOf("PROJECT_ID_") <= 0) continue;
            return false;
        }
        return true;
    }

    public static void removeSame(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = list.size() - 1; j > i; --j) {
                if (!list.get(j).get("tableName").equals(list.get(i).get("tableName"))) continue;
                list.remove(j);
            }
        }
    }

    public static ExportParams getExportParams(String fileName) {
        ExportParams exportParams = new ExportParams(null, fileName);
        exportParams.setStyle(EasyPoiStyle.class);
        exportParams.setType(ExcelType.XSSF);
        return exportParams;
    }

    public String gsRequestData(String transcode, String body) {
        return "{\"packet\": {\"head\": {\"transtype\":\"request\",\"transdate\":\"" + DateTime.now().toString("yyyMMdd") + "\"," + "\"transtime\":\"" + DateTime.now().toString("HHmmss") + "\"," + "\"transcode\":\"" + transcode + "\"}," + "\"body\":" + body + "}" + "}";
    }

    public JSONObject parseEsbResponse(String responseStr) {
        try {
            JSONObject jsonobject = JSONUtil.parseObj((String)responseStr);
            return jsonobject.getJSONObject((Object)"Service").getJSONObject((Object)"Data").getJSONObject((Object)"Response");
        }
        catch (Exception e) {
            return JSONUtil.parseObj((String)("{\"msg\":\"" + responseStr + "\"}"));
        }
    }

    public static Integer handleFileType(String suffix) {
        if ("bmp,jpg,jpeg,png,gif,webp".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.one.getCode());
        }
        if ("docx,doc,xls,xlsx,ppt,pptx,pdf,htl,html,txt".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.two.getCode());
        }
        if ("rar,zip,7z,gz,bz,ace,uha,uda,zpaq".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.three.getCode());
        }
        if ("avi,wmv,mpg,mpeg,mov,rm,ram,swf,flv,mp4".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.four.getCode());
        }
        return Integer.valueOf(FileTypeEnum.five.getCode());
    }
}

