/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.qualification.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseQualificationLabelManager;
import com.artfess.cgpt.expert.model.BizExpertDatabaseQualificationLabel;
import com.artfess.cgpt.project.manager.UserParticipationQualificationLabelManager;
import com.artfess.cgpt.project.model.UserParticipationQualificationLabel;
import com.artfess.cgpt.qualification.dao.BizQualificationLabelDao;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizQualificationLabelManagerImpl
extends BaseManagerImpl<BizQualificationLabelDao, BizQualificationLabel>
implements BizQualificationLabelManager {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizExpertDatabaseQualificationLabelManager expertDatabaseQualificationLabelManager;
    @Autowired
    private BizSupplierOrgQualificationLabelManager supplierOrgQualificationLabelManager;
    @Autowired
    private UserParticipationQualificationLabelManager userParticipationQualificationLabelManager;
    private final String QUALIFICATION_FROM = "3";

    @Override
    public PageList<BizQualificationLabel> queryAllByPage(QueryFilter<BizQualificationLabel> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizQualificationLabel> iPage = ((BizQualificationLabelDao)this.baseMapper).queryAllByPage((IPage<BizQualificationLabel>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizQualificationLabel>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional
    public String saveOrUpdateEntity(BizQualificationLabel entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        if ("3".equals(entity.getQualificationForm())) {
            entity.setQualificationMemberId(ContextUtil.getCurrentUser().getUserId());
            entity.setQualificationMember(ContextUtil.getCurrentUser().getFullname());
        }
        Assert.notNull((Object)entity.getQualificationMemberId(), (String)"\u8d44\u8d28\u5173\u8054\u6210\u5458ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)entity.getQualificationMember(), (String)"\u8d44\u8d28\u5173\u8054\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            if (BeanUtils.isEmpty((Object)entity.getQualificationCode())) {
                entity.setQualificationCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgpt_zzbm"));
            }
        } else {
            this.existData(entity);
            this.accessoryService.removeBySourceId(entity.getId());
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList)) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        return entity.getId();
    }

    @Override
    public BizQualificationLabel getDataById(String id) {
        BizQualificationLabel result = (BizQualificationLabel)((Object)super.getById((Serializable)((Object)id)));
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(result.getId()));
        return result;
    }

    @Override
    public void removeByIds(List<String> ids) {
        List bizQualificationLabelList = super.listByIds(ids);
        for (BizQualificationLabel data : bizQualificationLabelList) {
            this.existData(data);
        }
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void updateApprovalStatusById(String id, String status) {
        LambdaUpdateWrapper qualificationLabelUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)qualificationLabelUW.set(BizQualificationLabel::getApprovalStatus, (Object)status)).eq(BizQualificationLabel::getId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)qualificationLabelUW);
    }

    void existData(BizQualificationLabel data) {
        LambdaQueryWrapper expertDatabaseQW = new LambdaQueryWrapper();
        expertDatabaseQW.eq(BizExpertDatabaseQualificationLabel::getQualificationLabelId, (Object)data.getId());
        if (this.expertDatabaseQualificationLabelManager.count((Wrapper)expertDatabaseQW) > 0) {
            throw new BaseException("\u8d44\u8d28\u7f16\u7801\u3010" + data.getQualificationCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        LambdaQueryWrapper supplierOrgQualificationLabelQW = new LambdaQueryWrapper();
        supplierOrgQualificationLabelQW.eq(BizSupplierOrgQualificationLabel::getQualificationLabelId, (Object)data.getId());
        if (this.supplierOrgQualificationLabelManager.count((Wrapper)supplierOrgQualificationLabelQW) > 0) {
            throw new BaseException("\u8d44\u8d28\u7f16\u7801\u3010" + data.getQualificationCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        LambdaQueryWrapper userParticipationQualificationLabelQW = new LambdaQueryWrapper();
        userParticipationQualificationLabelQW.eq(UserParticipationQualificationLabel::getQualificationLabelId, (Object)data.getId());
        if (this.userParticipationQualificationLabelManager.count((Wrapper)userParticipationQualificationLabelQW) > 0) {
            throw new BaseException("\u8d44\u8d28\u7f16\u7801\u3010" + data.getQualificationCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
    }
}

