/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.purchasing.dao.BizPurchaseOrderDao;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderDetailManager;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderManager;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrderDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizPurchaseOrderManagerImpl
extends BaseManagerImpl<BizPurchaseOrderDao, BizPurchaseOrder>
implements BizPurchaseOrderManager {
    @Resource
    private BizPurchaseOrderDetailManager purchaseOrderDetailManager;
    @Resource
    private AccessoryService accessoryService;
    @Resource
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizContractManager contractManager;

    @Override
    public BizPurchaseOrder getDetailById(String id) {
        BizPurchaseOrder order = (BizPurchaseOrder)((Object)this.getById((Serializable)((Object)id)));
        List<BizPurchaseOrderDetail> details = this.purchaseOrderDetailManager.getListByOrderId(id);
        List<Accessory> accessories = this.accessoryService.getAccessoryBySourceId(id);
        order.setDetailsList(details);
        order.setAccessoryList(accessories);
        return order;
    }

    @Override
    @Transactional
    public void saveVo(BizPurchaseOrder entity) {
        LambdaUpdateWrapper contractUW;
        List<BizPurchaseOrderDetail> detailsList = entity.getDetailsList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<String> contractIdList = entity.getContractIdList();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            entity.setOrderCreatedate(LocalDateTime.now());
            if (BeanUtils.isEmpty((Object)entity.getOrderCode())) {
                String bacthNum = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgpt_cgdd");
                entity.setOrderCode(bacthNum);
            }
        } else {
            this.purchaseOrderDetailManager.delByOrderId(entity.getId());
            this.accessoryService.removeBySourceId(entity.getId());
            contractUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)contractUW.set(BizContract::getOrderId, null)).set(BizContract::getOrderStatus, (Object)0)).eq(BizContract::getOrderId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            this.contractManager.update((Wrapper)contractUW);
        }
        if (BeanUtils.isEmpty((Object)entity.getStatus())) {
            entity.setStatus(1);
        }
        this.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailsList) && detailsList.size() > 0) {
            detailsList.stream().forEach(s -> {
                s.setOrderId(entity.getId());
                s.setOrderCode(entity.getOrderCode());
            });
            this.purchaseOrderDetailManager.saveOrUpdateBatch(detailsList);
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        if (BeanUtils.isNotEmpty(contractIdList) && contractIdList.size() > 0) {
            contractUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)contractUW.set(BizContract::getOrderId, (Object)entity.getId())).set(BizContract::getOrderStatus, (Object)1)).in(BizContract::getId, contractIdList)).eq(BizModel::getIsDele, (Object)"0");
            this.contractManager.update((Wrapper)contractUW);
        }
    }

    @Override
    public PageList<BizPurchaseOrder> queryAllByPage(QueryFilter<BizPurchaseOrder> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList pageList = this.query(queryFilter);
        return pageList;
    }

    @Override
    public void removeData(List<String> ids) {
        LambdaQueryWrapper orderDetailQW = new LambdaQueryWrapper();
        orderDetailQW.in(BizPurchaseOrderDetail::getOrderId, ids);
        this.purchaseOrderDetailManager.remove((Wrapper)orderDetailQW);
        this.accessoryService.removeBySourceIds(ids);
        LambdaUpdateWrapper contractUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)contractUW.set(BizContract::getOrderId, null)).set(BizContract::getOrderStatus, (Object)0)).in(BizContract::getOrderId, ids)).eq(BizModel::getIsDele, (Object)"0");
        this.contractManager.update((Wrapper)contractUW);
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void confirmOrder(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizPurchaseOrder::getStatus, (Object)status)).set(BizPurchaseOrder::getOrderLastchgdate, (Object)LocalDateTime.now())).in(BizPurchaseOrder::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)uw);
    }

    @Override
    public PageList<BizPurchaseOrder> pageMatCompanyGroup(QueryFilter<BizPurchaseOrder> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizPurchaseOrder> result = ((BizPurchaseOrderDao)this.baseMapper).pageMatCompanyGroup((IPage<BizPurchaseOrder>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizPurchaseOrder>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

