import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '资质类型名称',
            prop: 'qualificationCategoryName',
            type: 'input',
            value: ''
        },
        {
            title: '资质类型编码',
            prop: 'qualificationCategoryCode',
            type: 'input',
            value: ''
        },
        {
            title: '姓名',
            prop: 'fullName',
            type: 'input',
            value: ''
        },
        {
            title: '行业分类',
            prop: 'industry',
            type: 'input',
            value: ''
        },
        {
            title: '发证机构',
            prop: 'issuingAuthority',
            type: 'input',
            value: ''
        },
        {
            title: '时间期限',
            prop: 'timeLimit',
            type: 'select',
            options: [
                { name: '限时', value: '0' },
                { name: '永久', value: '1' },
            ],
            value: '',
            span: 4
        },
        {
            title: '有效开始期',
            prop: 'issueDate',
            type: 'date',
            dateOption: {
                type: 'date',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '有效截止期',
            prop: 'validUntil',
            type: 'date',
            dateOption: {
                type: 'date',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '创建时间',
            prop: 'creationTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '资质名称',
            prop: 'name',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '资质编码',
            prop: 'code',
            type: 'input',
            value: '',
            span: 4
        },
        {
            title: '资质所属',
            prop: 'e.REGIS_TYPE_',
            type: 'select',
            options: [
                { name: '企业', value: '0' },
                { name: '个人', value: '1' },
            ],
            value: '',
            span: 4
        },
        {
            title: '企业名称',
            prop: 'e.ENTERPRISE_NAME',
            type: 'input',
            value: '',
            span: 4
        },
        {
            title: '状态',
            prop: 'stauts',
            type: 'select',
            options: [
                { name: '正常', value: '1' },
                { name: '到期', value: '2' },
                { name: '异常', value: '3' }
            ],
            value: '',
            span: 4
        },
        
    ]
    const columnsList: COption[] = [
        {
            title: '资质类型编码',
            prop: 'qualificationCategoryCode',
            minWidth: 160,
        },
        {
            title: '资质类型名称',
            prop: 'qualificationCategoryName',
            minWidth: 100,
        },
        {
            title: '资质编码',
            prop: 'code',
            minWidth: 160,
        },
        {
            title: '资质名称',
            prop: 'name',
            minWidth: 100,
        },
        {
            title: '资质所属',
            prop: 'qualificationAttribution',
            minWidth: 100,
            render: true,
        },
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 100,
        },
        {
            title: '姓名',
            prop: 'fullName',
            minWidth: 100,
        },
        {
            title: '行业分类',
            render: true,
            prop: 'industry',
            minWidth: 100,
        },
        {
            title: '发证机构',
            prop: 'issuingAuthority',
            minWidth: 100
        },
        {
            title: '时间期限',
            render: true,
            prop: 'timeLimit',
            minWidth: 100
        },
        {
            title: '有效开始期',
            prop: 'issueDate',
            minWidth: 100,
            sortable: true
        },
        {
            title: '有效截止期',
            prop: 'validUntil',
            minWidth: 100,
            render: true,
            sortable: true
        },
        {
            title: '状态',
            prop: 'status',
            render: true,
            minWidth: 100,
        },
        {
            title: '备注',
            prop: 'remarks',
            minWidth: 120,
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
